<dropable-container>
	<div class="position-relative round-corners d-block dropable-container-container"
		onclick={ openpicker }
		ondragover={ dragover }
		ondragenter={ dragenter }
		ondragleave={ dragleave }
		ondrop={ drop }
		style={ getUploaderStyle() }>
		<strong class="dropable-container-overlay {nohover: (progressVisible || nohover), dropable-dropping: dropping} position-absolute p-3 d-flex flex-column justify-content-center align-items-center w-100 h-100 cursor-pointer">
			<span class="p-2 align-items-center delete-button" onclick={clickDelete} onmouseover={deleteOver} onmouseout={deleteOut} show={bgImage}>
				<i class="far fa-fw fa-times"></i>
			</span>
			<div class="d-block"><i class="fas fa-upload mr-2"></i><span>Upload {opts.name}</span></div>
			<small class="" if={opts.subtext}>{opts.subtext}</small>
			<div class="progress bg-dark fullWidth align-self-end" style="width: 100%;" show={progressVisible}>
				<div class="progress-bar bg-primary" role="progressbar" style="width: {progress}%" show={exactProgress}>{Math.floor(progress)}%</div>
				<div class="progress-bar bg-primary progress-bar-striped progress-bar-animated" role="progressbar" style="width: 100%" hide={exactProgress}>{processText}</div>
			</div>
		</strong>
	</div>
	<input type="file" ref="input" class="d-none" onchange={ changeInput }>

	<script>
		this.dropping = false;
		this.nohover = false;
		this.progressVisible = false;
		this.progress = 0;
		this.exactProgress = true;
		this.bgImage = opts.bgImage;
		this.bgTimestamp = (new Date).getTime();
		var dragCount = 0;

		openpicker(evt) { this.refs.input.click(); }
		dragover(evt) { evt.preventDefault(); }
		dragenter() { this.dropping = ++dragCount !== 0; }
		dragleave() { this.dropping = --dragCount !== 0; }

		deleteOver() {
			this.nohover = true;
			this.update();
		}
		deleteOut() {
			this.nohover = false;
			this.update();
		}

		drop(evt) {
			evt.preventDefault();
			this.dropping = false;
			dragCount = 0;

			if (evt.dataTransfer.files.length === 0) return;

			var file = evt.dataTransfer.files[0];
			this.trigger('upload', file);
		}

		getUploaderStyle() {
			if (this.bgImage) {
				return {"background-image": 'url(' + this.bgImage + '?t=' + this.bgTimestamp + ')'};
			} else {
				return {};
			}
		}

		changeInput(evt) {
			if (evt.target.files.length > 0) {
				this.trigger('upload', evt.target.files[0]);
			}
			evt.target.value = "";
		}

		clickDelete(evt) {
			evt.preventDefault();
			evt.stopPropagation();
			this.trigger('delete');
		}

		this.on('show-progress', function() {
			this.progressVisible = true;
			this.exactProgress = false;
			this.update();
		}.bind(this));

		this.on('hide-progress', function() {
			this.progressVisible = false;
			this.update();
		}.bind(this));

		this.on('update-img', function(bgImage) {
			this.progressVisible = false;
			this.bgImage = bgImage;
			if (this.bgImage) {
				this.bgTimestamp = (new Date).getTime();
			}
			this.update();
		}.bind(this));

		this.on('progress-spin', function() {
			if (!this.progressVisible || !this.exactProgress) {
				return;
			}

			this.exactProgress = false;
			this.update();
		}.bind(this));

		this.on('progress', function(progress) {
			if (!this.progressVisible) {
				return;
			}

			if (this.exactProgress && this.progress === progress * 100) {
				return;
			}

			this.exactProgress = true;
			this.progress = progress * 100;
			this.update();
		}.bind(this));
	</script>
</dropable-container>