<socials-setup-modal class="modal fade" id="modal-socials-setup" tabindex="-1" role="dialog" aria-labelledby="modal-socials-setup">
	<div class="modal-dialog modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" data-i18n="channel.socials.title">Socials Setup</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
			<div class="modal-body">
				<h6 class="mb-2" data-i18n="channel.socials.tagline">Here you can add your social media links</h6>
				<div class="input-group mb-1">
					<div class="input-group-prepend">
						<select class="form-control w-100" ref="addSocialID" onchange={socialChange}>
							<option each={social, id in socials} value={id} selected={selectedSocial === id}>{social.name}</option>
						</select>
					</div>
					<input type="text" class="form-control form-control-sm" placeholder={i18n("channel.socials.link")} ref="addSocialURL" onkeypress={socialAddKey}>
					<div class="input-group-append">
						<button class="btn btn-sm" type="button" onclick={addSocial}>
							<i class="far fa-plus mr-1" hide={updating}></i>
							<i class="far fa-spinner fa-spin" show={updating}></i>
							<span>{getAddText()}</span>
						</button>
					</div>
				</div>
				<div class="text-danger my-1" show={error}>
					<i class="fas fa-exclamation-circle mr-1"></i>
					<strong>{error}</strong>
				</div>
				<h6 class="mt-4 mb-2" data-i18n="channel.socials.current">Your current socials</h6>
				<div>
					<div each={social, id in socials} show={socialsSet[id]} ref="social-{id}" class="my-1 {d-flex: socialsSet[id]} flex-row align-items-center">
						<i class="fab fa-{social.fa} fa-fw mr-2"></i>
						<button class="btn btn-link btn-sm mr-2 clickThruChildren" onclick={removeSocial} data-social-id={id}>
							<i class="far fa-times" hide={social.deleting}></i>
							<i class="far fa-spinner fa-spin" show={social.deleting}></i>
						</button>
						<a href={socialsSet[id]} class="text-muted {animateAll: !social.updateAnim, bg-success: social.updateAnim}" target="_blank" rel="nofollow noopener noreferrer">{socialsSet[id]}</a>
					</div>
				</div>
			</div>
		</div>
	</div>

	<script>
	this.updating = false;
	this.selectedSocial = "home";
	this.error = "";
	this.socials = {
		home: {
			name: i18n("channel.socials.homepage"),
			fa: "home fas",
			updateAnim: false,
			deleting: false,
			format: "%s"
		},
		tumblr: {
			name: "Tumblr",
			fa: "tumblr",
			updateAnim: false,
			deleting: false,
			format: "http://%s.tumblr.com/",
			match: /^(?:https?:\/\/)?(?:www\.)?tumblr.com\/(?:dashboard\/)?blog\/([\w\d_-]+)|^(?:https?:\/\/)?([\w\d-_]+)\.tumblr\.com/i
		},
		patreon: {
			name: "Patreon",
			fa: "patreon",
			updateAnim: false,
			deleting: false,
			format: "https://patreon.com/%s",
			match: /^(?:https?:\/\/)?(?:www\.)?patreon\.com\/([\w\d_-]+)/i
		},
		deviantart: {
			name: "DeviantArt",
			fa: "deviantart",
			updateAnim: false,
			deleting: false,
			format: "https://www.deviantart.com/%s/",
			match: /^(?:https?:\/\/)?(?:(?:www\.)?deviantart\.com\/([\w\d_-]+)|([\w\d_-]+)\.deviantart\.com)/i
		},
		pixiv: {
			name: "Pixiv",
			fa: "ptv-pixiv",
			updateAnim: false,
			deleting: false,
			format: "https://www.pixiv.net/member.php?id=%s",
			match: /^(?:https?:\/\/)?(?:www\.)?pixiv\.net\/member\.php\?id=(\d+)/i
		},
		facebook: {
			name: "Facebook",
			fa: "facebook",
			updateAnim: false,
			deleting: false,
			format: "https://www.facebook.com/%s",
			match: /^(?:https?:\/\/)?(?:www\.)?facebook\.com\/([\w\d_\.-]+)/i
		},
		googleplus: {
			name: "Google+",
			fa: "google",
			updateAnim: false,
			deleting: false,
			format: "https://plus.google.com/%s",
			match: /^(?:https?:\/\/)?plus.google.com\/([\d+]+)/i
		},
		twitter: {
			name: "Twitter",
			fa: "twitter",
			updateAnim: false,
			deleting: false,
			format: "https://twitter.com/%s",
			match: /^(?:https?:\/\/)?(?:www\.)?twitter\.com\/([\w\d_-]+)/i
		},
		youtube: {
			name: "YouTube",
			fa: "youtube",
			updateAnim: false,
			deleting: false,
			format: "https://www.youtube.com/channel/%s",
			match: /^(?:https?:\/\/)?(?:www\.)?youtube\.com\/(?:channel\/)?([\w\d_-]+)/i
		},
		furaffinity: {
			name: "Fur Affinity",
			fa: "ptv-furaffinity",
			updateAnim: false,
			deleting: false,
			format: "http://www.furaffinity.net/user/%s",
			match: /^(?:https?:\/\/)?(?:www\.)?furaffinity\.net\/user\/([\w\d_\.-]+)/i
		},
		hentaifoundry: {
			name: "Hentai Foundry",
			fa: "ptv-hentai-foundry",
			updateAnim: false,
			deleting: false,
			format: "https://hentai-foundry.com/user/%s/profile",
			match: /^(?:https?:\/\/)?(?:www\.)?hentai-foundry\.com\/user\/([\w\d_-]+)/i
		},
		tapastic: {
			name: "Tapas (Tapastic)",
			fa: "ptv-tapastic",
			updateAnim: false,
			deleting: false,
			format: "https://tapas.io/%s",
			match: /^(?:https?:\/\/)?(?:www\.)?(?:tapas\.io|tapastic\.com)\/([\w\d_-]+)/i
		},
		flickr: {
			name: "Flickr",
			fa: "flickr",
			updateAnim: false,
			deleting: false,
			format: "https://www.flickr.com/people/%s/",
			match: /^(?:https?:\/\/)?(?:www\.)?flickr\.com\/(?:people|photos)\/([\w\d_-]+)/i
		},
		instagram: {
			name: "Instagram",
			fa: "instagram",
			updateAnim: false,
			deleting: false,
			format: "https://www.instagram.com/%s/",
			match: /^(?:https?:\/\/)?(?:www\.)?instagram\.com\/([\w\d\._-]+)/i
		},
        weasyl: {
            name: "Weasyl",
            fa: "weasyl",
            updateAnim: false,
            deleting: false,
            format: "https://www.weasyl.com/~%s/",
            match: /^(?:https?:\/\/)?(?:www\.)?weasyl\.com\/~([\w\d\._-]+)/i
        }
	};

	this.socialsSet = opts.socials || {};

	close() {
		$(this.root).modal('hide');
	}

	getAddText() {
		if (this.socialsSet[this.refs["addSocialID"].value]) {
			return i18n("channel.socials.update");
		} else {
			return i18n("channel.socials.add");
		}
	}

	socialChange(evt) {
		this.selectedSocial = evt.currentTarget.value;
		this.update();
	}

	addSocial() {
		var id = this.refs["addSocialID"].value;
		var value = this.refs["addSocialURL"].value.trim();

		var valid = true;
		if (id === "home") {
			valid = /^https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&\/=]*)$/i.test(value);
		} else {
			if (!/^[\w\d-_]+$/.test(value)) {
				var match = value.match(this.socials[id].match);
				if (!match) {
					valid = false;
				} else {
					value = match.slice(1).find(function(e){return e !== undefined;});
				}

				if (typeof value === "undefined") {
					valid = false;
				}
			}

			value = this.socials[id].format.replace("%s", value);
		}

		if (!valid) {
			this.error = "Invalid social URL";
			return;
		}

		this.updating = true;
		this.update();

		$.post("/process/settings/socials", {
			"type": id,
			"value": value
		}).done(function(body) {
			try {
				var status = JSON.parse(body);
				if (status.status !== "ok") {
					this.error = status.error;
					return this.update();
				}
			} catch(e) {
				this.error = body;
				return this.update();
			}

			this.error = "";
			this.socialsSet[id] = value;
			this.refs["addSocialURL"].value = "";
			this.socials[id].updateAnim = true;
			this.update();

			// Clone the object to prevent providing the real object to global scope
			ptvbus.trigger('update-socials', Object.assign({}, this.socialsSet));
			setTimeout(function() {
				this.socials[id].updateAnim = false;
				this.update();
			}.bind(this), 5);
		}.bind(this)).fail(function(jqxhr) {
			try {
				this.error = JSON.parse(jqxhr.responseText).error;
			} catch(e) {
				this.error = jqxhr.responseText;
			}

			this.update();
		}.bind(this)).always(function() {
			this.updating = false;
			this.update();
		}.bind(this));
	}

	socialAddKey(evt) {
		if (evt.keyCode == 13) {
			this.addSocial();
		}
	}

	removeSocial(evt) {
		var id = evt.target.dataset["socialId"];
		var socialRoot = this.refs["social-" + id];
		this.socials[id].deleting = true;
		$.post("/process/settings/socials", {
			"type": id,
			"value": ""
		}).success(function() {
			delete this.socialsSet[id];
			this.update();

			// Clone the object to prevent providing the real object to global scope
			ptvbus.trigger('update-socials', Object.assign({}, this.socialsSet));
		}.bind(this)).fail(function(jqxhr) {
			try {
				this.error = JSON.parse(jqxhr.responseText).error;
			} catch(e) {
				this.error = jqxhr.responseText;
			}

			this.update();
		}.bind(this)).always(function() {
			this.socials[id].deleting = false;
			this.update();
		}.bind(this));

	}
	</script>
</socials-setup-modal>