<private-stream-setup-modal class="modal fade" id="modal-private-setup" tabindex="-1" role="dialog" aria-labelledby="modal-private-setup">
	<div class="modal-dialog modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" data-i18n="channel.private_modal.title">Private Stream</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
			<div class="modal-body">
				<div data-i18n="channel.private_modal.head">In Private mode, your channel is only accessible through the URL below.</div>
				<small class="text-muted mb-3 d-block" data-i18n="channel.private_modal.head_note">Please note that recordings are disabled for private streams</small>
				<h6 data-i18n="channel.private_modal.access_head">Channel Access Message</h6>
				<div class="mb-3">
					<textarea class="form-control mb-1 {animateAll: updateMotdAnim === 0, bg-success: updateMotdAnim === 1, bg-danger: updateMotdAnim === -1}" ref="motd" onchange={setMotd}>{motd}</textarea>
					<small class="text-muted d-block" data-i18n="channel.private_modal.access_note">This message will be displayed if people want to access your channel while private mode is enabled. Links will automatically be made clickable.</small>
				</div>
				<h6 data-i18n="channel.private_modal.key_head">Private Stream key</h6>
				<div class="input-group input-group-sm mb-2">
					<input type="text" class="form-control {animateAll: updateKeyAnim === 0, bg-success: updateKeyAnim === 1, bg-danger: updateKeyAnim === -1}" value={privateKey} onchange={updateKey} maxlength="32">
				</div>
				<small class="text-muted mb-1 d-block" data-i18n="channel.private_modal.key_note">Must be between 3 and 32 characters, and must be alphanumeric.</small>
				<div class="">
					<button class="btn btn-sm clickThruChildren mr-2 mb-2" type="button" onclick={copyURL} ref="copyBtn">
						<i class="fas fa-copy mr-1"></i>
						<span data-i18n="channel.private_modal.copy">Copy Direct Link</span>
					</button>
					<button class="btn btn-sm mb-2" type="button" onclick={newKey}>
						<i class="fas fa-sync mr-1"></i>
						<span data-i18n="channel.private_modal.random">Generate Random Key</span>
					</button>
				</div>
				<small class="text-muted mb-1 d-block" data-i18n="channel.private_modal.share">Share this link with caution!</small>
			</div>
			<div class="modal-footer justify-content-center">
				<!-- Show depending of Status -->
				<button class="btn btn-primary" type="button" onclick={setPrivate} hide={private} data-i18n="channel.private_modal.set_private">Set Private</button>
				<button class="btn btn-primary" type="button" onclick={setPublic} show={private} data-i18n="channel.private_modal.set_public">Set Public</button>
			</div>
		</div>
	</div>

	<script>
		this.regularURL = document.location.protocol + "//" + document.location.host + "/" + document.location.pathname.split("/")[1];
		this.privateKey = opts.privateKey || "";
		var updatedKey = false;
		this.private = opts.private || false;
		this.motd = opts.motd || "";
		this.updateKeyAnim = 0;
		this.updateMotdAnim = 0;

		newKey() {
			$.post("/process/settings/channel", {type: "genKey"}, function(body) {
				var data;
				try {
					data = JSON.parse(body);
				} catch(e) {
					displayErrorMsg(182);
					return;
				}

				if (data.status !== "ok") {
					displayErrorMsgCustom("Error: " + data.error);
					this.updateKeyAnim = -1;
					this.update();
					return;
				}

				this.updateKeyAnim = 1;
				this.privateKey = data.key;
				if (this.private) {
					updatedKey = true;
				}
				this.update();
			}.bind(this));
		}

		copyURL(evt) {
			setClipboard(this.regularURL + "/" + this.privateKey);

			var jqTarget = $(evt.target);

			jqTarget.attr("data-original-title", "Copied!");
			jqTarget.tooltip('hide').tooltip('show');
			setTimeout(function() {
				jqTarget.one('show.bs.tooltip', function() {
					jqTarget.attr("data-original-title", "Click to copy");
				});
			}, 5);
		}

		close() {
			$(this.root).modal('hide');
		}

		updateKey(evt) {
			$.post("/process/settings/channel", {type: "setPrivateKey", key: evt.target.value}, function(body) {
				var data;
				try {
					data = JSON.parse(body);
				} catch(e) {
					displayErrorMsg(182);
					return;
				}

				if (data.status !== "ok") {
					displayErrorMsgCustom("Error: " + data.error);
					this.updateKeyAnim = -1;
					this.update();
					return;
				}

				this.updateKeyAnim = 1;
				this.privateKey = data.key;
				if (this.private) {
					updatedKey = true;
				}
				this.update();
			}.bind(this));
		}

		setPrivate() {
			$.post("/process/settings/channel", {type: "setPrivate", enable: 1}, function(body) {
				var data;
				try {
					data = JSON.parse(body);
				} catch(e) {
					displayErrorMsg(182);
					return;
				}

				if (data.status !== "ok") {
					displayErrorMsgCustom("Error: " + data.error);
					return;
				}

				this.privateKey = data.key;
				this.private = true;
				updatedKey = true;
				this.update();
				ptvbus.trigger('private-mode', true);
				this.close();
			}.bind(this));
		}

		setPublic() {
			$.post("/process/settings/channel", {type: "setPrivate", enable: 0}, function(body) {
				var data;
				try {
					data = JSON.parse(body);
				} catch(e) {
					displayErrorMsg(182);
					return;
				}

				if (data.status !== "ok") {
					displayErrorMsgCustom("Error: " + data.error);
					return;
				}

				this.private = false;
				updatedKey = true;
				this.update();
				ptvbus.trigger('private-mode', false);
				this.close();
			}.bind(this));
		}

		setMotd() {
			$.post("/process/settings/channel", {type: "setMotd", motd: this.refs["motd"].value}, function(body) {
				var data;
				try {
					data = JSON.parse(body);
				} catch(e) {
					displayErrorMsg(182);
					return;
				}

				if (data.status !== "ok") {
					displayErrorMsgCustom("Error: " + data.error);
					this.updateMotdAnim = -1;
					this.update();
					setTimeout(function () {
						this.updateMotdAnim = 0;
						this.update();
					}.bind(this), 10);
					return;
				}

				this.updateMotdAnim = 1;
				this.update();
				setTimeout(function () {
					this.updateMotdAnim = 0;
					this.update();
				}.bind(this), 10);
			}.bind(this));
		}

		this.on('mount', function() {
			$(this.refs["copyBtn"]).tooltip({
				title: "Click to copy",
				placement: "top"
			});

			$(this.root).on('hide.bs.modal', function() {
				if (updatedKey) {
					updatedKey = false;
					if (typeof window.history === "object" && typeof window.history.replaceState === "function") {
						window.history.replaceState(null, document.title, this.regularURL + (this.private ? "/" + this.privateKey : ""));
					} else {
						document.body.style.pointerEvents = 'none';
						$("body").animate({opacity: 0}, function() {
							window.location.reload();
						});
					}
				}
			}.bind(this));
		}.bind(this));

		this.on('updated', function() {
			if (this.updateMotdAnim !== 0) {
				this.updateMotdAnim = 0;
				setTimeout(this.update.bind(this), 10);
			}

			if (this.updateKeyAnim !== 0) {
				this.updateKeyAnim = 0;
				setTimeout(this.update.bind(this), 10);
			}
		}.bind(this));
	</script>
</private-stream-setup-modal>