<multistream-modal class="modal fade" tabindex="-1" role="dialog">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" data-i18n="multi_manager.title">Manage Multistreams</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
			<div class="modal-body">
				<!-- Block Content -->
				<div if={premium}>
					<h6 data-i18n="multi_manager.incoming.header">Invite users to your multistream</h6>
					<div class="input-group mb-3">
						<input class="form-control" id="multi-invite-username" data-i18n="[placeholder]multi_manager.placeholder" type="text" placeholder="User to invite" ref="inviteInput" disabled={Object.keys(outgoing).length >= max_invites} onkeydown={invite_keydown}/>
						<span class="input-group-append">
							<button type="button" class="btn" id="multi-invite-username" onclick={invite} disabled={Object.keys(outgoing).length >= max_invites}>
								<i class="fas fa-user-plus mr-1"></i>
								<span data-i18n="multi_manager.incoming.invite">Invite</span>
							</button>
						</span>
					</div>
					<div class="mb-5">
						<h6 class="text-muted"><span data-i18n="multi_manager.incoming.sent">Invitations sent</span> ({Object.keys(outgoing).length} / {max_invites})</h6>
						<multistream-invitation-outgoing each={state, channel in outgoing} channel={channel} ready={state.ready} deleting={state.deleting} accepted={state.accepted} uid={state.uid} ondelete={del_outgoing}/>
					</div>
				</div>
				<div class="mb-4" if={!premium}>
					<h6 class="text-center mb-4" data-i18n="multi_manager.outgoing.tease_title">Want to invite your friends to your own multistream?</h6>
					<div class="text-center">
						<a href="/site/upgrade">
							<button class="btn btn-primary text-uppercase"><span data-i18n="menu.upgrade">Upgrade</span><i class="fas fa-chevron-right ml-3"></i></button>
						</a>
					</div>
				</div>
				<div>
					<h6 class="text-muted"><span data-i18n="multi_manager.outgoing.received">Invitations received</span> ({Object.keys(incoming).length})</h6>
					<p class="mb-2 text-white" if={user_accepted}><small><i class="fas fa-info-circle mr-2"></i><span data-i18n="multi_manager.outgoing.clash_warning">You have to leave your current multistream to join a new one</span></small></p>
					<multistream-invitation-incoming each={state, channel in incoming} can_accept={!user_accepted} accepting={state.accepting} accepted={user_accepted == channel} uid={state.uid} channel={channel} deleting={state.deleting} onaccept={accpet_incoming} onreject={reject_incoming}/>
				</div>
				<!-- Block Content ENDE -->
			</div>
		</div>
	</div>

	<style>
		/* Simulate div */
		:scope {
			display: block;
		}
	</style>

	<script>
		var self = this;

		self.premium = opts.premium || false;
		self.max_invites = opts.max_invites || 3;
		self.outgoing = opts.outgoing || {
			desti: {
				uid: 368871,
				ready: true,
				deleting: false,
				accepted: true
			},
			slugbox: {
				uid: 41,
				ready: true,
				deleting: false,
				accepted: true
			},
			Calm: {
				uid: 1454,
				ready: true,
				deleting: false,
				accepted: false
			}
		};

		self.user_accepted = opts.user_accepted || "";
		self.incoming = opts.incoming || {
			PicartoTVLikeMike: {
				uid: 3,
				deleting: false,
				accepting: false
			},
			slugbox: {
				uid: 41,
				deleting: false,
				accepting: false
			},
			Pikachu: {
				uid: 7796,
				deleting: false,
				accepting: false
			}
		};

		// Lookup a channel by name, get real name + user ID
		function lookupChannel(channel, callback) {
			$.get("https://api.picarto.tv/v1/channel/name/" + channel)
				.done(function(body) {
					var data;
					if (typeof body === "object") {
						data = body;
					} else {
						try {
							data = JSON.parse(body);
						} catch(e) {
							console.log(e, body);
							callback(0, channel);
							return;
						}
					}

					if (typeof callback === "function") {
						callback(data.user_id, data.name);
					}
				})
				.fail(function() {
					// no-op for now
					if (typeof callback === "function") {
						callback(0, channel);
					}
				});
		}

		invite_keydown(evt) {
			if (evt.keyCode === 13) {
				self.invite();
			}
		}

		invite() {
			var channel = self.refs["inviteInput"].value;
			self.refs["inviteInput"].value = "";

			if (Object.keys(self.outgoing).find(function(elem){return elem.toLowerCase() === channel.toLowerCase()})) {
				displayNotificationMsg(19);
				return;
			}

			self.outgoing[channel] = {
				uid: 0,
				ready: false,
				deleting: false,
				accepted: false
			};
			self.update();

			lookupChannel(channel, function(uid, realChannel) {
				delete self.outgoing[channel];
				if (uid === 0) {
					displayNotificationMsg(20);
					self.update();
					return;
				}

				channel = realChannel;
				self.outgoing[channel] = {
					uid: uid,
					ready: false,
					deleting: false,
					accepted: false
				};
				self.update();

				$.post("/process/settings/multistream", {
					type: "multistream",
					channelToInvite: channel
				}).done(function (body) {

					var notificationValid = false;
					var data;

					var setSuccessfully = (function() {
						var msgID = 0;
						var isError = false;
						try {
							data = JSON.parse(body);

							if(data.privatemode == 1){
								msgID = 33;
							} else {
								switch(data.update){
									case 1:
										return true;
									case "alreadyInvited":
										msgID = 19;
										break;
									case "selfInvited":
										msgID = 18;
										break;
									case "channelNotFound":
										msgID = 20;
										break;
									case "maxInvReached":
										msgID = 17;
										break;
									case "guestOrHost":
										msgID = 22;
										break;
									case "error":
										msgID = 230;
										isError = true;
										break;
									default:
										msgID = 231;
										isError = true;
										break;
								}
							}
						} catch(e) {
							msgID = 219;
							isError = true;
						}

						if (isError) {
							displayErrorMsg(msgID);
						} else {
							displayNotificationMsg(msgID);
						}
						return false;
					})();

					if (setSuccessfully) {
						self.outgoing[channel].ready = true;
					} else {
						delete self.outgoing[channel];
					}
					self.update();
				})
				.fail(function () {
					displayErrorMsg(219);
				});
			});
		}

		del_outgoing(userid, channel) {
			this.outgoing[channel].deleting = true;
			this.update();

			$.post("/process/settings/multistream", {
                type: "multistream",
                removeMultistream: userid
			}).done(function(body) {
				var data;
				try {
					data = JSON.parse(body);
				} catch(e) {
					displayErrorMsg(224);
				}

				if (data.removed === 1) {
					delete self.outgoing[channel];
					self.update();
				} else {
					displayErrorMsg(224);
				}
			}).fail(function() {
				displayErrorMsg(224);
			});
		}

		accpet_incoming(userid, channel) {
			// TODO: Rewrite backend to allow this to just use one handler

			self.incoming[channel].accepting = true;
			self.update();

			$.post("/process/settings/multistream", {
                type: "multistream",
                acceptInvitation: userid
			}).done(function(body) {
				var data;
				var success = (function() {
					var msgID = 0;
					var isError = false;
					try {
						data = JSON.parse(body);

						if(data.privatemode === 1) {
							msgID = 33;
						} else {
							switch(data.invitationAccepted){
								case 1:
									return true;
								case "alreadyAccepted":
									msgID = 22;
									break;
								case "channelError":
									msgID = 20;
									break;
								case "updateError":
									msgID = 225;
									isError = true;
									break;
								default:
									msgID = 226;
									isError = true;
									break;
							}
						}
					} catch(e) {
						msgID = 222;
						isError = true;
					}

					if (isError) {
						displayErrorMsg(msgID);
					} else {
						displayNotificationMsg(msgID);
					}
					return false;
				})();

				if (success) {
					self.user_accepted = channel;
				}

				self.incoming[channel].accepting = false;
				self.update();
			}).fail(function() {
				displayErrorMsg(222);
				self.incoming[channel].accepting = false;
				self.update();
			});
		}

		reject_incoming(userid, channel) {
			this.incoming[channel].deleting = true;
			this.update();

			$.post("/process/settings/multistream", {
                type: "multistream",
                leaveMultistream: userid
			}).done(function(body) {
				var data;
				try {
					data = JSON.parse(body);
				} catch(e) {
					displayErrorMsg(223);
				}

				if (data.multistreamLeft === 1) {
					delete self.incoming[channel];
					self.user_accepted = "";
					self.update();
				} else {
					displayErrorMsg(223);
				}
			}).fail(function() {
				displayErrorMsg(223);
			});
		}

		update_notification_counter() {
			var elem = document.getElementById("multiNotificationCounter");
			var incomingCount = Object.keys(this.incoming).length;
			if (this.user_accepted) {
				--incomingCount;
			}
			if (incomingCount !== 0) {
				elem.textContent = incomingCount;
				elem.style.display = "";
			} else {
				elem.style.display = "none";
			}
		}

		window.ptvbus.on('multistream-invitation', function(data) {
			lookupChannel(data, function(uid, channel) {
				self.incoming[channel] = {
					uid: uid,
					deleting: false,
					accepting: false
				};
				self.update();
			});
		});

		window.ptvbus.on('multistream-remove', function(data) {
			lookupChannel(data, function(uid, channel) {
				if (channel === self.user_accepted) {
					self.user_accepted = "";
				}
				delete self.incoming[channel];
				self.update();
			});
		});

		window.ptvbus.on('multistream-accept', function(data) {
			lookupChannel(data, function(uid, channel) {
				self.outgoing[channel].accepted = true;
				self.update();
			});
		});

		window.ptvbus.on('multistream-leave', function(data) {
			lookupChannel(data, function(uid, channel) {
				delete self.outgoing[channel];
				self.update();
			});
		});

		this.on('mount', function() {
			this.update_notification_counter();
		})

		this.on('updated', function() {
			this.update_notification_counter();
		})
	</script>
</multistream-modal>

<multistream-invitation-outgoing>
	<p class="multi-invited d-flex flex-row align-items-center">
		<a href="/{opts.channel}">
			<img class="avatar35 roundAvatar mr-2" src="https://picarto.tv/user_data/usrimg/{opts.channel.toLowerCase()}/dsdefault.jpg" title="{opts.channel} on Picarto" if={opts.ready}>
		</a>
		<i class="far fa-spinner fa-spin fa-2x mr-2" if={!opts.ready}></i>
		<span class="d-inline-flex justify-content-center flex-column">
			<a class="text-white" href="/{opts.channel}"><span>{opts.channel}</span></a>
			<small class="text-muted">{get_accept_state()}</small>
		</span>
		<span class="ml-auto">
			<button type="button" class="btn btn-sm btn-link" onclick={del_invite} disabled={!opts.ready || opts.deleting}>
				<i class="far fa-fw fa-times" hide={opts.deleting}></i>
				<i class="far fa-fw fa-spinner fa-spin" show={opts.deleting}></i>
			</button>
		</span>
	</p>

	<script>
		get_accept_state() {
			if (opts.accepted) {
				return "Accepted";
			} else {
				return "Waiting to accept";
			}
		}

		del_invite() {
			opts.ondelete(opts.uid, opts.channel);
		}
	</script>
</multistream-invitation-outgoing>

<multistream-invitation-incoming>
	<p class="multi-invited d-flex flex-row align-items-center">
		<a href="/{opts.channel}">
			<img class="avatar35 roundAvatar mr-2" src="https://picarto.tv/user_data/usrimg/{opts.channel.toLowerCase()}/dsdefault.jpg" title="{opts.channel} on Picarto">
		</a>
		<span class="d-inline-flex justify-content-center flex-column">
			<a class="text-white" href="/{opts.channel}"><span>{opts.channel}</span></a>
			<small class="text-muted" show={opts.accepted} data-i18n="multi_manager.invitation.accepted">Accepted</small>
		</span>
		<span class="ml-auto">
			<button type="button" class="btn btn-sm btn-primary ml-2" onclick={accept_invite} disabled={!opts.can_accept || opts.deleting}>
				<i class="far fa-fw fa-check ml-1" hide={opts.accepting}></i>
				<i class="far fa-fw fa-spinner fa-spin" show={opts.accepting}></i>
				<span data-i18n="multi_manager.invitation.accept">Accept</span>
			</button>
			<button type="button" class="btn btn-sm btn-link" onclick={reject_invite} disabled={opts.deleting}>
				<i class="far fa-fw fa-times" hide={opts.deleting}></i>
				<i class="far fa-fw fa-spinner fa-spin" show={opts.deleting}></i>
			</button>
		</span>
	</p>

	<script>
		reject_invite() {
			opts.onreject(opts.uid, opts.channel);
		}

		accept_invite() {
			opts.onaccept(opts.uid, opts.channel);
		}

	</script>
</multistream-invitation-incoming>