<livestream-setup class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modal-livestream-setup">
	<div class="modal-dialog modal-md" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" data-i18n="tutorial.title">Livestream Setup</h5>
				<button type="button" class="close" aria-label="Close" onclick={closeSetup}>
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
			<div class="modal-body">
				<!-- Only on first start -->
				<div ref="step1" class="collapse {show: firstTime}">
					<h5 class="text-muted" data-i18n="tutorial.step1.title">How to stream on Picarto</h5>
					<h6 class="mb-4" data-i18n="tutorial.step1.description">Step 1: Download and install broadcasting software</h6>
					<div class="d-flex flex-row align-items-center mb-3 py-2 px-0">
						<span>
							<div>Streamlabs OBS</div>
							<small class="text-primary d-block">
								<i class="fas fa-thumbs-up mr-1"></i>
								<span data-i18n="tutorial.step1.recommended">Recommended</span>
							</small>
							<small class="text-muted">Windows</small>
						</span>
						<a class="ml-auto" target="_blank" href="https://www.streamlabs.com/streamlabs-obs"><button class="btn btn-sm btn-link" data-i18n="tutorial.step1.download">Download</button></a>
					</div>
					<div class="d-flex flex-row align-items-center py-2  px-0">
						<span>
							<div>OBS Studio</div>
							<small class="text-muted">Windows, Mac, Linux</small>
						</span>
						<a class="ml-auto"  target="_blank" href="https://obsproject.com/"><button class="btn btn-link btn-sm" data-i18n="tutorial.step1.download">Download</button></a>
					</div>
					<div class="p-2 mt-4 text-center">
						<button class="btn btn-primary" onclick={setTab.bind(this, 2)}><span data-i18n="tutorial.next">Next</span><i class="fas fa-arrow-right fontSize0-8 ml-2"></i></button>
					</div>
				</div>
				<div ref="step2" class="collapse">
					<h6 class="mb-4" data-i18n="tutorial.step2.description">Step 2: Setup broadcasting software</h6>
					<div class="d-flex flex-row align-items-center mb-3 py-2 px-0">
						<span>
							<div>Streamlabs OBS</div>
							<small class="text-muted">Windows</small>
						</span>
						<span class="ml-auto d-flex flex-column">
							<a target="_blank" href="https://www.youtube.com/watch?v=vti-tNKpnvk"><button class="btn btn-link btn-sm mb-1 btn-block text-right" data-i18n="tutorial.step2.video_tutorial_windows">Windows Tutorial (Video)</button></a>
							<a class="ml-auto" target="_blank" href="https://picarto.groovehq.com/knowledge_base/topics/how-to-configure-streamlabs-obs"><button class="btn btn-sm btn-link text-right" data-i18n="tutorial.step2.tutorial_windows">Windows Tutorial</button></a>
						</span>
					</div>
					<div class="d-flex flex-row align-items-center py-2  px-0">
						<span>
							<div>OBS Studio</div>
							<small class="text-muted">Windows, Mac</small>
						</span>
						<span class="ml-auto d-flex flex-column">
							<a target="_blank" href="http://help.picarto.tv/knowledge_base/topics/how-to-configure-open-broadcaster-software"><button class="btn btn-link btn-sm mb-1 btn-block text-right" data-i18n="tutorial.step2.tutorial_windows">Windows Tutorial</button></a>
							<a target="_blank" href="https://picarto.tv/tutorials/mactutorial"><button class="btn btn-link btn-sm mb-1 btn-block text-right" data-i18n="tutorial.step2.tutorial_mac">Mac Tutorial</button></a>
						</span>
					</div>
					<div class="p-2 mt-4 text-center">
						<button class="btn btn-primary" onclick={setTab.bind(this, 3)}><span data-i18n="tutorial.next">Next</span><i class="fas fa-arrow-right fontSize0-8 ml-2"></i></button>
					</div>
				</div>
				<div ref="step3" class="collapse {show: !firstTime}">
					<h6 class="mb-4" data-i18n="tutorial.step3.description">Step 3: Choose Server</h6>
						<div each={uri, name in servers} class="d-flex flex-row align-items-end mb-3 py-2 px-0">
						<span>
							<h6 class="text-muted">{name} <span data-i18n="tutorial.step3.server">Server</h6>
							<div>{uri}</div>
						</span>
						<button class="btn btn-link btn-sm ml-auto py-0 clickThruChildren" data-copy>
							<input value={uri} data-copy-src>
							<i class="fas fa-copy mr-1"></i>
							<span data-i18n="tutorial.step3.copy">Copy</span>
						</button>
					</div>
					<div class="d-flex flex-column mb-3 py-2 px-0">
						<div class="mb-3">
							<h6 class="text-muted" data-i18n="tutorial.step3.stream_key">Your Stream Key</h6>
							<div id="streamKeyDisplay" class="">{displayStreamKey()}</div>
						</div>
						<div class="text-left d-flex flex-row w-100">
							<button class="btn  btn-link btn-sm clickThruChildren" onclick={generateKey}>
								<i class="fas fa-sync-alt mr-1"></i>
								<span data-i18n="tutorial.step3.new_key">New Key</span>
							</button>
							<span class="ml-auto">
								<button class="btn btn-sm btn-link clickThruChildren" onclick={showStreamKey} hide={streamKeyVisible}>
									<i class="fas fa-eye mr-1"></i>
									<span data-i18n="tutorial.step3.show">Show</span>
								</button>
								<button class="btn btn-sm  btn-link clickThruChildren" onclick={hideStreamKey} show={streamKeyVisible}>
									<i class="fas fa-eye-slash mr-1"></i>
									<span data-i18n="tutorial.step3.hide">Hide</span>
								</button>
								<button class="btn btn-sm btn-link clickThruChildren" data-copy>
									<input id="streamKeyCopier" value={streamKey} data-copy-src>
									<i class="fas fa-copy mr-1"></i>
									<span data-i18n="tutorial.step3.copy">Copy</span>
								</button>
							</span>
						</div>
					</div>
					<div class="p-2 mt-4 text-center">
						<button hide={showRestart} class="btn btn-primary" onclick={endTutorial} data-i18n="tutorial.step3.finish">Finish Tutorial</button>
						<button show={showRestart} class="btn btn-sm" onclick={restartTutorial} data-i18n="tutorial.step3.restart">Start setup tutorial again</button>
					</div>
				</div>
			</div>
		</div>
	</div>

	<script>
		this.streamKey = opts.streamKey || "";
		this.firstTime = opts.firstTime || false;
		this.showRestart = !this.firstTime;
		var showRestartCue = false;
		this.streamKeyVisible = false;
		this.servers = {
			"US East": "rtmp://live.us-east1.picarto.tv/golive",
			"US West": "rtmp://live.us-west1.picarto.tv/golive",
			"EU West": "rtmp://live.eu-west1.picarto.tv/golive"
		};

		displayStreamKey() {
			if (this.streamKeyVisible) {
				return this.streamKey;
			} else {
				return "●●●●●●●●";
			}
		}

		showStreamKey() {
			this.streamKeyVisible = true;
		}

		hideStreamKey() {
			this.streamKeyVisible = false;
		}

		closeSetup() {
			$(this.root).modal('hide');
		}

		setTab(id) {
			for (var i = 1; i <= 3; ++i) {
				$(this.refs["step" + i]).collapse(i === id ? "show" : "hide");
			}
		}

		generateKey() {
			$.post("/process/settings/livestreamsetup", {type: "genNewKey"}, function(body) {
				var data;
				try {
					data = JSON.parse(body);
				} catch(e) {
					displayNotificationMsg(101);
					return;
				}

				if (data.streamkey != -1) {
					this.streamKey = data.streamkey;
					this.update();
				} else {
					displayNotificationMsg(101);
				}
			}.bind(this));
		}

		endTutorial() {
			if (this.firstTime) {
				this.firstTime = false;
				$.post("/process/settings/livestreamsetup", {type: "tutorialDone"});
			}
			showRestartCue = true;
			$(this.root).modal('hide');
		}

		restartTutorial() {
			this.showRestart = false;
			this.setTab(1);
		}

		this.on('mount', function() {
			$(this.root).on('hidden.bs.modal', function() {
				if (showRestartCue) {
					showRestartCue = false;
					this.showRestart = true;
					this.update();
				}
			}.bind(this));
		}.bind(this));
	</script>
</livestream-setup>