<user-bar class="border-bottom border-dark">
	<user-bar-view class="bg-light position-relative w-100 d-flex align-items-stretch px-3" ref="collapseRoot">
		<span id="userbar-avatar" class="user-avatar mr-1 mr-lg-3 d-flex align-items-center" no-collapse>
			<img class="avatar35 avatar-mobile border roundAvatar {border-warning: opts.premium, border-info: opts.basic}" src="/user_data/usrimg/{opts.channelName.toLowerCase()}/dsdefault.jpg" title="{opts.channelName} on Picarto">
		</span>
		<span id="userbar-name" class="user-name d-inline-flex flex-column justify-content-center py-1 flex-nowrap" no-collapse>
			<span class="d-flex align-items-center">
				<h6 class="text-white d-inline-block m-0">{opts.channelName}</h6>
				<i if={opts.verified} data-i18n="[title]channel.account_status_verified" class="user-badge textShadow fontSize0-9 d-inline-flex fas fa-check-circle text-primary ml-1" title="Verified Channel"></i>
				<i if={opts.premium} data-i18n="[title]channel.account_status_premium" class="user-badge textShadow fontSize0-9 d-inline-flex fas fa-star text-warning ml-1" title="Premium"></i>
				<i if={opts.basic} data-i18n="[title]channel.account_status_basic" class="user-badge textShadow d-inline-flex fas fa-ptv-basic text-info ml-1" title="Basic"></i>
				<span class="online-badge ml-1 badge badge-danger d-inline-flex align-items-center noSelect" if={live[opts.channelID]}><i class="fas fa-circle mr-1 fontSize0-5"></i>LIVE</span>
			</span>
			<small class="d-block text-muted">
				<span class="mr-2" title="Follower">
					<i class="fas fa-heart"></i>
					<span class="cursor-default">{opts.followers}</span>
				</span>
				<span if={canSubscribe && subsVisible} title="Subscriber">
					<i class="fas fa-hand-receiving"></i>
					<span class="cursor-default">{opts.subscribers}</span>
				</span>
                <span class="gifted_by_channel" if={opts.gifted} title={this.giftedby_title} >
                    <i class="fas fa-gift text-warning"></i>
                </span>
			</small>
		</span>
		<span class="menu-item ml-2 ml-lg-4 d-flex align-items-center cursor-pointer {active: !videosVisible}" onclick={showStream}>
			<span class="btn bg-transparent px-0" data-i18n="channel.stream">Stream</span>
		</span>
		<span class="menu-item ml-2 ml-lg-4 d-flex align-items-center cursor-pointer {active: videosVisible}" onclick={showVideos} data-content="<img src='{opts.vidThumb}' class='round-corners my-2 d-block mx-auto video-tooltip w-100'>Watch past broadcasts" ref="videoTabBtn">
			<span class="btn bg-transparent px-0"><span data-i18n="channel.videos_tab">Videos</span><small class="text-muted d-inline-block badge">{opts.videos}</small></span>
		</span>
		<span class="user-buttons d-flex align-self-center ml-3">
			<!-- Add class "followed" if user followed -->
			<button if={!isStreamer} class="follow-button-ptv btn btn-sm btn-primary font-weight-bold text-uppercase" onclick={follow} hide={followed}>
				<i class="fas fa-heart mr-0 mr-lg-1"></i>
				<span class="d-inline-block" data-i18n="channel.follow">Follow</span>
			</button>

			<span show={followed}>
				<div class="dropdown mr-1">
					<button type="button" class="btn btn-sm btn-link dropdown-toggle px-2" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
						<i class="fas fa-heart mr-0 mr-lg-1"></i>
					</button>
					<div class="dropdown-menu text-center text-dark p-3" style="min-width: 240px;">
						<h2></h2>
						<div class="d-block text-left d-flex align-items-center mb-3">
							<span class="mr-2" data-i18n="notifications.title">Notifications</span>
							<input class="checkslider ml-auto" type="checkbox" onchange={updateNotifications} checked={notificationsEnabled}>
						</div>
						<button class="btn btn-sm btn-block btn-secondary" onclick={unfollow} hide={confirmingUnfollow}><span data-i18n="channel.unfollow">Unfollow</span></button>
						
						<span class="btn-group w-100" show={confirmingUnfollow}>
							<button class="btn-sm btn btn-block m-0" onclick={cancelUnfollow}><i class="far fa-fw fa-times clickThru"></i></button>
							<button class="btn-sm btn btn-block btn-danger m-0" onclick={confirmUnfollow}><i class="far fa-fw fa-check clickThru"></i></button>
						</span>
					</div>
				</div>
			</span>

			<a href="/subscribe/{opts.channelName}" if={!isStreamer} show={canSubscribe}>
				<button class="btn btn-primary font-weight-bold text-uppercase btn-sm ml-2 subscribe_button position-relative" ref="subscribeButton">
					<i class="fas fa-hand-receiving mr-0 mr-lg-1"></i>
					<span class="d-inline-block" data-i18n="channel.subscribe">Subscribe</span>
				</button>
			</a>

            <a href="/gift/premium/{opts.channelName}/{opts.channelID}" if={!opts.premium}>
                <button class="btn btn-secondary font-weight-bold btn-sm ml-2 position-relative" ref="premiumButton">
                    <i class="fas fa-gift mr-0 mr-lg-1"></i>
                </button>
            </a>

			<div if={!isStreamer} class="d-none" ref="subscribeTooltip">
				<div class="text-left py-2">
					<h5 class="text-uppercase text-center" data-i18n="channel.subscribe">Subscribe</h5>
					<div class="text-center">
						<img class="roundAvatar avatar35 mb-2" src="/user_data/usrimg/{opts.channelName.toLowerCase()}/dsdefault.jpg">
					</div>
					<h6 class="mb-3 cutLine text-uppercase text-center">{opts.channelName}</h6>
					<div class="mb-2 d-flex align-items-center">
						<i class="fas fa-plus text-primary mr-2"></i>
						<span class="mr-1" data-i18n="channel.sperks.support_streamer">Support</span>
						<span>{opts.channelName}</span>
					</div>
					<div class="mb-2 d-flex align-items-center">
						<i class="fas fa-plus text-primary mr-2"></i>
						<span data-i18n="channel.sperks.emojis">Use streamers chat emojis</span>
					</div>
					<div class="mb-2 d-flex align-items-center">
						<i class="fas fa-plus  text-primary mr-2"></i>
						<span data-i18n="channel.sperks.raffles">Enter subscriber only raffles</span>
					</div>
					<div class="mb-0 d-flex align-items-center">
						<i class="fas fa-plus  text-primary mr-2"></i>
						<span data-i18n="channel.sperks.chat_icon">Chat icon</span>
					</div>
				</div>
			</div>

            <div if={!isStreamer} if={!opts.premium} class="d-none" ref="giftPremiumTooltip">
                <div class="text-left py-2">
                    <h5 class="text-uppercase text-center" data-i18n="subscribe.gift_premium_header">Gift Premium</h5>
                    <div class="text-center">
                        <img class="roundAvatar avatar35 mb-2" src="/user_data/usrimg/{opts.channelName.toLowerCase()}/dsdefault.jpg">
                    </div>
                    <h6 class="mb-3 cutLine text-uppercase text-center">{opts.channelName}</h6>
                    <div class="mb-2 d-flex align-items-center">
                        <i class="fas fa-plus text-primary mr-2"></i>
                        <span class="mr-1" data-i18n="channel.sperks.support_streamer">Support</span>
                        <span>{opts.channelName}</span>
                    </div>
                    <div class="mb-2 d-flex align-items-center">
                        <i class="fas fa-plus text-primary mr-2"></i>
                        <span data-i18n="channel.sperks.unlock">Unlock all Premium features for the streamer</span>
                    </div>
                </div>
            </div>

		</span>
		<span ref="collapseMarker" class="collapse-dropdown-container dropdown d-flex" no-collapse>
			<button class="btn btn-link collapsed dropdown-toggle hide-toggle ml-1 pr-0" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" show={hasCollapsedElements}>
				<i class="fas fa-ellipsis-v"></i>
			</button>
			<span class="dropdown-menu bg-secondary dropdown-menu-right p-2 text-center" ref="collapsedElems">
			</span>
		</span>
		<span class="multistream-container ml-auto d-flex justify-content-center align-items-center dropdown" if={opts.multistream && opts.multistream.length} no-collapse>
			<button class="btn btn-link collapsed dropdown-toggle d-xl-none ml-1 pr-0" id="multi-users-button" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
				<i class="fas fa-th-large"></i>
			</button>
			<span class="multi-users-container dropdown-menu dropdown-menu-right flex-row p-1 text-center" aria-labelledby="multi-users-button">
				<h6 class="dropdown-header" data-i18n="channel.multi_participants">Multistream Participants</h6>
				<user-bar-avatar-menu-dropdown each={channel in opts.multistream} name={channel.name} channel-id={channel.id} user-id={opts.userID} minimized={channel.minimized} expanded={expandedId === channel.id} following={channel.following} live={live[channel.id]} onmouseover={multiOver.bind(this, channel)} onmouseout={multiOut.bind(this, channel)}/>
			</span>
			<span class="userbar-multistream-hover-target d-flex">
				<span each={channel in opts.multistream} class="user-avatar ml-2 d-none d-xl-flex align-items-center cursor-pointer animateAll" onmouseover={multiOver.bind(this, channel)} onmouseout={multiOut.bind(this, channel)}>
					<span class="dropdown">
						<img class="avatar35 avatar-icon roundAvatar {avatar-offline: !live[channel.id]} {avatar-minimized: channel.minimized}" src="/user_data/usrimg/{channel.name.toLowerCase()}/dsdefault.jpg" title="Click for more" data-toggle="dropdown">
						<div class="dropdown-menu dropdown-menu-right p-0 border-0">
							<div class="d-flex align-items-center text-center bg-primary p-2 rounded-top">
								<img class="avatar25 roundAvatar mr-2" src="/user_data/usrimg/{channel.name.toLowerCase()}/dsdefault.jpg" title="{channel.name} on Picarto">
								<h6 class="text-white m-0">{channel.name}</h6>
							</div>
							<user-bar-avatar-menu-inner name={channel.name} channel-id={channel.id} user-id={opts.userID} minimized={channel.minimized} expanded={expandedId === channel.id} following={channel.following} live={live[channel.id]}/>
						</div>
					</span>
				</span>
			</span>
		</span>
	</user-bar-view>
	<user-bar-notification/>

	<script>
		this.followed = opts.followed || false;
		this.live = {};
		this.live[opts.channelID] = opts.live || false;
		this.isStreamer = (opts.userID === opts.channelID) || false;
		this.videosVisible = false;
		this.canSubscribe = (opts.followed && opts.canSubscribe) || false;
		this.subsVisible = opts.subsVisible || false;
		this.confirmingUnfollow = false;
		this.tooltipTimer = 0;
		this.expandedId = 0;
		this.hasCollapsedElements = false;
		this.notificationsEnabled = opts.notificationsEnabled || false;

		//if we want to translate dynamically within an area where we can not seperate content from variables
        this.giftedby_title = i18n("channel.giftedby", {user: opts.gifted_by}) || "";

        i18n("channel.sperks.emojis");

		Object.keys(opts.multistream).forEach(function(key) {
			var elem = opts.multistream[key];
			this.live[elem.id] = elem.online;
		}.bind(this));

		// TODO: Does not work fully, calculations are incorrect for rightPos
		recalculateCollapse() {
			var rootWidth = Math.min(this.refs["collapseRoot"].clientWidth - 16, window.innerWidth) - 81; // 81 for multi btn + expand btn
			Array.prototype.slice.call(this.refs["collapseRoot"].children).reverse()
				.filter(function(elem) { return !elem.hasAttribute("no-collapse"); })
				.forEach(function(elem, idx) {
					var rightPos = elem.offsetWidth + elem.offsetLeft;

					// First element should be checked without button padding
					if ((idx === 0 ? rootWidth + 26 : rootWidth) < rightPos) {
						elem.setAttribute("right-pos", rightPos);
						var collapsedElems = this.refs["collapsedElems"];
						collapsedElems.insertBefore(elem, collapsedElems.childNodes[0]);
					}
				}.bind(this));

			Array.prototype.slice.call(this.refs["collapsedElems"].children)
				.forEach(function(elem, idx) {
					// First element should be checked without button padding
					if ((idx === 0 ? rootWidth + 26 : rootWidth) >= parseInt(elem.getAttribute("right-pos"))) {
						this.refs["collapseRoot"].insertBefore(elem, this.refs["collapseMarker"]);
					}
				}.bind(this));

			var hadCollapsed = this.hasCollapsedElements;
			this.hasCollapsedElements = this.refs["collapsedElems"].children.length !== 0;
			if (hadCollapsed !== this.hasCollapsedElements) {
				this.update();
			}
		}

		follow() {
			if (this.followed) {
				return;
			}

			this.followed = true;
			$.post("/process/channel", { follow: opts.channelID }, function (data) {
				window.ptvbus.trigger('follow-channel', {id: opts.channelID, name: opts.channelName});
				if (data === 'followed') {
					return;
				}

				if (data == 'followerror') {
					displayErrorMsg(100);
				} else if (data == 'notallowed') {
					$('#menu_login_modal').modal('show');
				} else if (data == 'follownotallowed') {
					displayNotificationMsg(2);
					this.isStreamer = true;
				}

				this.update();
			}.bind(this));
		}

		this.updateNotifications = debounce(function(evt) {
			if (this.followed) {
				$.post("/process/channel", {
					channel_id: opts.channelID,
					notifications: evt.originalTarget.checked ? 1 : 0
				});
			}
		}.bind(this), 1000, true)

		showStream() {
			window.ptvbus.trigger('switch-stream-tab', 'stream');
		}

		showVideos() {
			window.ptvbus.trigger('switch-stream-tab', 'videos');
		}

		window.ptvbus.on('switch-stream-tab', function(state) {
			switch(state) {
				case 'stream':
					$('#player-container').show();
					$(".streamer-informations").addClass("d-md-block");
					$("#video-container").addClass("d-none");
					$("#player-container").removeClass("floating-player");
					$("#player-container").removeClass("on-videos");
					break;

				case 'videos':
					$("#video-container").removeClass("d-none");
					$(".streamer-informations").removeClass("d-md-block");
					$("#player-container").addClass("floating-player");
					$("#player-container").addClass("on-videos");
					$("#playerTempHeight").remove();
					this.hideTooltip();
					break;
			}

			this.videosVisible = state === 'videos';
			$('#player-container').perfectScrollbar("update");
		}.bind(this));

		unfollow() {
			this.confirmingUnfollow = true;
		}

		cancelUnfollow() {
			this.confirmingUnfollow = false;
		}

		confirmUnfollow() {
			this.followed = false;
			this.confirmingUnfollow = false;
			$.post("/process/settings/connections", {
				type: "unfollow",
				follower_id: opts.channelID
			}).done(function(body) {
				try {
					if (JSON.parse(body).update === -1) {
						displayErrorMsgCustom("You cannot unfollow someone you are subscribed to!");
						this.followed = true;
						this.update();
						return;
					}
				} catch(e) {}
				window.ptvbus.trigger('unfollow-channel', {id: opts.channelID, name: opts.channelName});
			}.bind(this)).fail(function() {
				displayErrorMsg(213);
			});
		}

		showTooltip() {
			if (!opts.vidThumb) {
				return;
			}
			clearTimeout(this.tooltipTimer);
			this.tooltipTimer = setTimeout(function() {
				var tooltipAnchor = $(this.refs["videoTabBtn"]);
				tooltipAnchor.popover('show');
				this.tooltipTimer = setTimeout(tooltipAnchor.popover.bind(tooltipAnchor, 'hide'), 10000);
			}.bind(this), 1000);
		}

		hideTooltip() {
			if (!opts.vidThumb) {
				return;
			}
			clearTimeout(this.tooltipTimer);
			window.ptvbus.trigger('hide-all-popovers');
		}

		multiOver(channel, evt) {
			window.ptvbus.trigger('shade-multi-player', channel.id);
		}

		multiOut(channel, evt) {
			window.ptvbus.trigger('shade-multi-player', 0);
		}

		window.ptvbus.on('multi-minimize-player-update', function(data) {
			this.expandedId = 0;
			this.opts.multistream.find(function(elem) {return elem.id === data.id}).minimized = data.state;
			this.update();
		}.bind(this));

		window.ptvbus.on('multi-expand-player-update', function(channelID) {
			this.expandedId = channelID;
			this.opts.multistream.forEach(function(elem) {elem.minimized = channelID === 0 ? false : channelID !== elem.id;});
			this.update();
		}.bind(this));

		window.ptvbus.on('hide-all-popovers', function() {
			$(this.refs["videoTabBtn"]).popover('hide');
		}.bind(this));

		window.ptvbus.on('channel-live', function(data) {
			if (this.live[data.id] === data.live) {
				return;
			}

			this.live[data.id] = data.live;

			this.update();
			if (data.id === opts.channelID) {
				if (data.live) {
					this.hideTooltip();
				} else {
					this.showTooltip();
				}
			}
		}.bind(this));

		window.ptvbus.on('follow-channel', function(data) {
			if (data.id === opts.channelID) {
				this.confirmingUnfollow = false;
				this.followed = true;
				this.notificationsEnabled = true;
				this.update();
			}
		}.bind(this));

		window.ptvbus.on('unfollow-channel', function(data) {
			if (data.id === opts.channelID) {
				this.confirmingUnfollow = false;
				this.followed = false;
				this.update();
			}
		}.bind(this));

		window.ptvbus.on('multi-update-users', function(data) {
			this.opts.multistream = data.map(function(elem) {
				return {
					id:   elem.channel,
					name: elem.channelName,
					minimized: this.expandedId !== 0 ? this.expandedId !== elem.channel : false,
				};
			}.bind(this));
			// This is looked up and updated seperately, we do not need to worry about this, could lead to stale state being displayed
			//this.live = data.reduce(function(obj, elem) {
			//	obj[elem.channel] = elem.live;
			//	return obj;
			//}, {});
			this.update();
		}.bind(this));

		// Handle restoring of follow states
		window.ptvbus.on('logged-in', function(data) {
			opts.userID = data.userid;

			var checkArr = opts.multistream;
			var toCheck = checkArr.length;

			// Fall back to single user if we are not in a multi
			if (toCheck === 0) {
				checkArr = [{id: opts.channelID, name: opts.channelName}];
				toCheck = 1;
			}


			for (var i = 0; i < checkArr.length; ++i) {
				(function(channel) {
				$.get("/process/channel", { connections: true, channel_name: channel.name })
					.done(function(body) {
						var data;
						try {
							data = JSON.parse(body);
						} catch(e) {
							console.warn(body, e);
						}

						if (data.data[0].followed) {
							window.ptvbus.trigger('follow-channel', {id: channel.id, name: channel.name});
						}

						if (--toCheck === 0) {
							this.update();
						}
					}.bind(this));
				}.bind(this))(checkArr[i]);
			}

			this.update();
		}.bind(this));

		this.on('mount', function() {
		    var refs = this.refs

        // we need
        // var refs = this.refs
        // and
        // aslInject('i18n', function() {});
        // for translations

            if (!this.isStreamer) {
                aslInject('i18n', function() {
				    $(refs["subscribeButton"]).tooltip({
                        title: refs["subscribeTooltip"].innerHTML,
                        html: true,
                        position: "bottom"
    				});
                });
			}

            if (!this.isStreamer) {
                aslInject('i18n', function() {
                    $(refs["premiumButton"]).tooltip({
                        title: refs["giftPremiumTooltip"].innerHTML,
                        html: true,
                        position: "bottom"
                    });
                });
            }

			if (opts.vidThumb) {
				$(this.refs["videoTabBtn"]).popover({
					html: true,
					placement: "bottom",
					trigger: "manual"
				});

				if (!this.live) {
					$(document).ready(this.showTooltip.bind(this));
				}
			}

			this.recalculateCollapse();
		});

		this.on('update', function() {
			this.canSubscribe = this.followed && opts.canSubscribe;
		});

		this.on('updated', this.recalculateCollapse);

		this.on('collapse-multi-accordion', function(toIgnore) {
			var tags = this.tags["user-bar-avatar-menu-dropdown"];
			if (!(tags instanceof Array)) {
				tags = [tags];
			}

			tags.forEach(function(elem) {
				if (elem !== toIgnore) {
					elem.collapse();
				}
			});
		}.bind(this));

		window.addEventListener('resize', function() {
			this.recalculateCollapse();
		}.bind(this), false);
	</script>
</user-bar>

<user-bar-notification class="userbar-notification bg-secondary px-3 py-1 animated-400 align-items-center slideInDown {slideOutUp: hiding}" hide={hidden}>
	<span class="mr-2"><i class="far fa-info-circle"></i></span>
	<span class="mr-2">{content}</span>
	<span class="ml-auto">
		<button each={action, idx in actions} class="btn btn-sm btn-primary mr-2 {action.classes}" onclick={doAction.bind(this, idx, action)}>{action.text}</button>
		<span class="cursor-pointer btn btn-sm btn-link text-white clickThruChildren" onclick={hide}><i class="far fa-times"></i></span>
	</span>

	<script>
		this.content = "$CONTENT";
		this.actions = [];
		this.hiding = false;
		this.hidden = true;

		var shortAnimTime = getShortAnimatedTime();

		function getShortAnimatedTime() {
			var elem = document.createElement("span");
			elem.className = "animated-400 d-none";
			document.body.appendChild(elem);
			var duration = getComputedStyle(elem).animationDuration;
			elem.remove();
			return parseFloat(duration)*1000;
		}

		show(data) {
			if (!this.hiding && !this.hidden) {
				window.ptvbus.on('userbar-action', false);
			}

			if (typeof data === "string") {
				data = {text: data, actions: []};
			}
			this.content = data.text;
			this.actions = data.actions;
			this.hiding = false;
			this.hidden = false;
			this.update();
		}

		hide() {
			window.ptvbus.on('userbar-action', false);
			this.hiding = true;
			this.update();
			setTimeout(function() {
				this.hidden = true;
				this.update();
			}.bind(this), shortAnimTime);
		}

		doAction(idx, btn) {
			if (this.hiding || this.hidden) {
				return;
			}

			this.hide();

			window.ptvbus.trigger('userbar-action', Object.assign({id: idx}, btn));
		}

		window.ptvbus.on('userbar-notification', this.show.bind(this));
	</script>
</user-bar-notification>

<user-bar-avatar-menu-dropdown>
	<div class="text-left cursor-pointer">
		<div class="dropdown-item" onclick={toggleCollapse}>
			<img class="avatar25 roundAvatar mr-2  {avatar-offline: !opts.live} {avatar-minimized: opts.minimized}" src="/user_data/usrimg/{opts.name.toLowerCase()}/dsdefault.jpg" title="{opts.name} on Picarto">
			<span>{opts.name}</span>
		</div>
		<div class="collapse" ref="collapseTarget">
			<user-bar-avatar-menu-inner name={opts.name} channel-id={opts.channelId} user-id={opts.userId} minimized={opts.minimized} expanded={opts.expanded} following={opts.following} live={opts.live}/>
		</div>
	</div>

	<script>
		collapse() {
			$(this.refs["collapseTarget"]).collapse('hide');
		}

		toggleCollapse() {
			this.parent.trigger('collapse-multi-accordion', this);
			$(this.refs["collapseTarget"]).collapse('toggle');
		}
	</script>
</user-bar-avatar-menu-dropdown>

<user-bar-avatar-menu-inner>
	<div class="py-2">
		<a href="/{encodeURI(opts.name)}"><div class="d-flex align-items-center dropdown-item"><i class="fas fa-fw fa-video mr-3"></i><span data-i18n="channel.channel">Channel</span></div></a>
		<virtual if={opts.channelId !== opts.userId}>
			<div class="{following ? "d-none" : "d-flex"} align-items-center dropdown-item clickThruChildren" onclick={follow}><i class="fas fa-fw fa-heart mr-3"></i><span data-i18n="channel.follow">Follow</span></span></div>
		</virtual>
	
		<virtual if={opts.live}>
			<div class="d-flex align-items-center dropdown-item clickThruChildren" onclick={hide}><i class="fas fa-fw {fa-times-square: !opts.minimized, fa-plus-square: opts.minimized} mr-3"></i>{opts.minimized ? "Show" : "Hide"} Stream</div>
			<div class="d-flex align-items-center dropdown-item clickThruChildren" onclick={expand}><i class="fas fa-fw {fa-expand-alt: !opts.expanded, fa-compress-alt: opts.expanded} mr-3"></i>{opts.expanded ? "Collapse" : "Expand"} Stream</div>
		</virtual>
	</div>

	<script>
		this.following = opts.following;

		hide() {
			window.ptvbus.trigger('multi-minimize-player', opts.channelId);
		}

		expand() {
			window.ptvbus.trigger('multi-expand-player', opts.channelId);
		}

		follow() {
			if (this.following) {
				return;
			}

			this.following = true;
			$.post("/process/channel", { follow: opts.channelId }, function (data) {
				window.ptvbus.trigger('follow-channel', {id: opts.channelId, name: opts.name});
				if (data === 'followed') {
					return;
				}

				if (data == 'followerror') {
					displayErrorMsg(100);
				} else if (data == 'notallowed') {
					$('#menu_login_modal').modal('show');
				} else if (data == 'follownotallowed') {
					displayNotificationMsg(2);
				}

				this.update();
			}.bind(this));
		}

		window.ptvbus.on('follow-channel', function(data) {
			if (data.id === opts.channelId) {
				this.following = true;
				this.update();
			}
		}.bind(this));

		window.ptvbus.on('unfollow-channel', function(data) {
			if (data.id === opts.channelId) {
				this.following = false;
				this.update();
			}
		}.bind(this));
	</script>
</user-bar-avatar-menu-inner>