<block-streaminfo>
	<channel-streaminfo channel={channel} channel-id={opts.channelID} streamer={streamer} online={online} viewers={viewers} product={product} color={color}
		communities={communities} software={software} languages={languages}
		gamemode={gamemode} mature={mature} commissions={commissions}
		channel-title={channelTitle} channel-tags={channelTags} total-views={totalViews}
		curr-community={currCommunity} curr-software={currSoftware} curr-language={currLanguage}
		tablet={tablet}
		home-link={homeLink} social-links={socialLinks}
		offline-image={offlineImage} chat-banner={chatBanner}
		panel1={panel1} panel2={panel2}
		panel1-link={panel1Link} panel2-link={panel2Link}
		hide-ads={hideAds}
		desc-panels={descPanels}
		private={private}/>

	<script>
		this.channel       = opts.channel || "";
		this.channelID     = opts.channelID || 0;
		this.online        = opts.online || false;
		this.streamer      = opts.streamer || false;
		this.viewers       = opts.viewers || 0;
		this.product       = opts.product || 0;
		this.color         = opts.color || "1da456";
		this.channelTags   = opts.channelTags ? opts.channelTags.split(",") : [];
		this.totalViews    = opts.totalViews || 0;
		this.communities   = opts.communities || [];
		this.software      = opts.software || [];
		this.languages     = opts.languages || [];
		this.gamemode      = opts.gamemode || false;
		this.mature        = opts.mature || false;
		this.commissions   = opts.commissions || false;
		this.currCommunity = opts.currCommunity || 1;
		this.currSoftware  = opts.currSoftware || 1;
		this.currLanguage  = opts.currLanguage === undefined ? 56 : opts.currLanguage;
		this.tablet        = opts.tablet || "";
		this.channelTitle  = opts.channelTitle || "Channel Title";
		this.homeLink      = opts.homeLink || "";
		this.socialLinks   = opts.socialLinks || {};
		this.offlineImage  = opts.offlineImage || false;
		this.chatBanner    = opts.chatBanner || false;
		this.panel1        = opts.panel1 || false;
		this.panel2        = opts.panel2 || false;
		this.panel1Link    = opts.panel1Link || "";
		this.panel2Link    = opts.panel2Link || "";
		this.hideAds       = opts.hideAds || false;
		this.descPanels    = opts.descPanels || {panels: [], columns: 4};
		this.private       = opts.private || false;
	</script>
</block-streaminfo>

<channel-streaminfo>
	<div class="streamer_infos position-relative">
		<channel-streaminfo-viewer hide={admin_view}
			channel={channel} channel-id={channelID} streamer={streamer} online={online} viewers={viewers} product={product}
			channel-title={channelTitle}
			gamemode={gamemode} mature={mature} commissions={commissions}
			home-link={homeLink} social-links={socialLinks}
			community={currCommunity} community-name={communities[currCommunity]}
			software={currSoftware} software-name={software[currSoftware]}
			language={currLanguage} language-name={languages[currLanguage]}
			tablet={tablet}
			channel-tags={channelTags}
			viewers={viewers}
			total-views={totalViews}
			panel1={panel1} panel2={panel2}
			panel1-link={panel1Link} panel2-link={panel2Link}
			events={events}
			hide-ads={hideAds}
			desc-panels={descPanels}
			private={private}/>

		<channel-streaminfo-admin if={streamer} show={admin_view}
			channel={channel} channel-id={channelID} online={online} viewers={viewers} product={product} channel-title={channelTitle} color={color}
			gamemode={gamemode} mature={mature} commissions={commissions}
			community={currCommunity} communities-list={communitiesOrder}
			software-list={softwareOrder} software={currSoftware} channel-tags={channelTags}
			language={currLanguage} language-list={languagesOrder}
			tablet={tablet}
			offline-image={offlineImage} chat-banner={chatBanner}
			panel1={panel1} panel2={panel2}
			panel1-link={panel1Link} panel2-link={panel2Link}
			events={events}
			desc-panels={descPanels}
			private={private}/>

		<span class="admin-scrolltarget position-absolute {scroll-bottom: admin_view}" ref="adminScrollTarget"></span>
	</div>

	<script>
		var self = this;
		this.events = riot.observable();
		this.admin_view = false;

		processSocials(socials) {
			var allSocials = Object.keys(this.socialLinks || {});
			var removed = 0;

			allSocials.slice().forEach(function (elem, idx) {
				if (this.socialLinks.hasOwnProperty(elem)) {
					this.socialLinks[elem].href = socials[elem];
					allSocials.splice(idx - (removed++), 1);
				}
			}.bind(this));

			allSocials.forEach(function (elem) {
				this.socialLinks[elem].href = "";
			}.bind(this));
		}

		processCommunities(communities) {
			communities.forEach(function (elem) {
				this.communities[elem.id] = elem.name;
			}.bind(this));
		}

		processSoftware(software) {
			software.forEach(function (elem) {
				this.software[elem.id] = elem.name;
			}.bind(this));
		}

		processLanguages(languages) {
			languages.forEach(function (elem) {
				this.languages[elem.id] = elem.name;
			}.bind(this));
		}

		adminScroll() {
			var scrolling = true;
			setTimeout(function(){scrolling = false;}, 500);

			var queueScroll;

			var runScroll = function() {
				if (scrolling) {
					queueScroll(runScroll);
				}
				this.refs["adminScrollTarget"].scrollIntoView({behavior: "instant", block: "nearest", inline: "nearest"});
			}.bind(this);

			if (requestAnimationFrame) {
				queueScroll = requestAnimationFrame;
			} else {
				// A lot more jittery (~30fps) but it works
				queueScroll = function(cb) {
					setTimeout(cb, 33);
				};
			}

			queueScroll(runScroll);
		}

		this.channel = opts.channel;
		this.channelID = opts.channelId;
		this.streamer = opts.streamer;
		this.online = opts.online;
		this.viewers = opts.viewers;
		this.product = opts.product;
		this.color = opts.color;
		this.channelTags = opts.channelTags;
		this.totalViews = opts.totalViews;
		this.communities = {};
		this.communitiesOrder = opts.communities;
		this.software = {};
		this.softwareOrder = opts.software;
		this.languages = {};
		this.languagesOrder = opts.languages;
		this.tablet = opts.tablet;
		this.gamemode = opts.gamemode;
		this.mature = opts.mature;
		this.commissions = opts.commissions;
		this.currCommunity = opts.currCommunity;
		this.currSoftware = opts.currSoftware;
		this.currLanguage = opts.currLanguage;
		this.channelTitle = opts.channelTitle;
		this.homeLink = opts.homeLink;
		this.offlineImage = opts.offlineImage;
		this.chatBanner = opts.chatBanner;
		this.panel1 = opts.panel1;
		this.panel2 = opts.panel2;
		this.panel1Link = opts.panel1Link;
		this.panel2Link = opts.panel2Link;
		this.socialLinks = {
			tumblr: { href: "", icon: "tumblr" },
			twitter: { href: "", icon: "twitter" },
			patreon: { href: "", icon: "patreon" },
			facebook: { href: "", icon: "facebook" },
			googleplus: { href: "", icon: "google" },
			youtube: { href: "", icon: "youtube" },
			flickr: { href: "", icon: "flickr" },
			instagram: { href: "", icon: "instagram" },
			deviantart: { href: "", icon: "deviantart" },
			furaffinity: { href: "", icon: "ptv-furaffinity" },
			pixiv: { href: "", icon: "ptv-pixiv" },
			tapastic: { href: "", icon: "ptv-tapastic" },
			hentaifoundry: { href: "", icon: "ptv-hentai-foundry" },
			weasyl: { href: "", icon: "fa-weasyl" }
		};
		this.hideAds = opts.hideAds;
		this.descPanels = opts.descPanels;
		this.private = opts.private;

		this.processCommunities(opts.communities);
		this.processSoftware(opts.software);
		this.processLanguages(opts.languages);
		this.processSocials(opts.socialLinks);

		var sendChatUpdate = function (type, value) {
			if (window.socket) {
				window.socket.Emit('Control', new proto.Control([proto.Control.MessageType[type], !!value]));
			}
		}.bind(this);

		var setContentType = debounce(function (community) {
			$.post("/process/dashboard", { setContentType: community }, function (data) {
				self.currCommunity = community;
				sendChatUpdate("CONTENT_TYPE");
			});
		}.bind(this), 500, true);

		var setSoftware = debounce(function (software) {
			$.post("/process/dashboard", { setSoftware: software }, function (data) {
				self.currSoftware = software;
			});
		}.bind(this), 500, true);

		var setLanguage = debounce(function (language) {
			$.post("/process/dashboard", { setLanguage: language }, function (data) {
				self.currLanguage = language;
			});
		}.bind(this), 500, true);

		var setTablet = debounce(function (tablet) {
			$.post("/process/dashboard", { setTablet: tablet }, function (data) {
				self.tablet = tablet;
			});
		}.bind(this), 500, true);

		var setTags = debounce(function (tags) {
			$.post("/process/dashboard", { setTags: tags }, function (data) {
				self.channelTags = tags.split(",");
			})
		}, 2000, true);

		this.events.on('update-title', function (title) {
			$.post("/process/dashboard", { setChannelTitle: title }, function (data) {
				var success = data === "titleOk";

				self.events.trigger('update-title-response', success);
				if (success) {
					self.channelTitle = title;
				}
			});
		}.bind(this));

		this.events.on('update-community', function (community) {
			setContentType(community);
		}.bind(this));

		this.events.on('update-software', function (software) {
			setSoftware(software);
		}.bind(this));

		this.events.on('update-language', function (language) {
			setLanguage(language);
		}.bind(this));

		this.events.on('update-tablet', function (tablet) {
			setTablet(tablet);
		}.bind(this));

		this.events.on('update-tags', function (tags) {
			setTags(tags);
		}.bind(this));

		this.events.on('panel-image', function (state) {
			this["panel" + state.id] = state.exists;
			this.update();
		}.bind(this));

		this.events.on('update-banner-link', function (state) {
			this["panel" + state.id + "Link"] = state.value;
			this.update();
		}.bind(this));

		this.events.on('player-background', function(state) {
			this.offlineImage = state;
			this.update();
		}.bind(this));

		this.events.on('chat-banner', function(state) {
			this.chatBanner = state;
			this.update();
		}.bind(this));

		window.ptvbus.on('set-gamemode', function (value) {
			$.post("/process/dashboard", { setGameMode: value ? 1 : 0 }).done(function () {
				self.gamemode = value;
				self.update();
				sendChatUpdate("GAMING", value);
			});
		}.bind(this));

		window.ptvbus.on('set-mature', function (value) {
			$.post("/process/dashboard", { setNsfw: value ? 1 : 0 }).done(function () {
				self.mature = value;
				self.update();
				sendChatUpdate("ADULT", value);
			});
		}.bind(this));

		window.ptvbus.on('set-commissions', function (value) {
			$.post("/process/dashboard", { setCommission: value ? 1 : 0 }).done(function () {
				self.commissions = value;
				self.update();
				sendChatUpdate("COMMISSIONS", value);
			});
		}.bind(this));

		window.ptvbus.on('gamemode-update', function(value) {
			this.gamemode = value;
			this.update()
		}.bind(this));

		window.ptvbus.on('mature-update', function(value) {
			this.mature = value;
			this.update()
		}.bind(this));

		window.ptvbus.on('commissions-update', function(value) {
			this.commissions = value;
			this.update()
		}.bind(this));

		window.ptvbus.on('set-channel-color', function (value) {
			$.post("/process/dashboard", { setChannelColor: value }).done(function (body) {
				var data;
				try {
					data = JSON.parse(body);
				} catch(e) {
					displayErrorMsg(431);
				}

				switch (data.status) {
					case "ok":
						self.color = value;
						break;
					case "unchanged":
						break;

					default:
						displayErrorMsgCustom(data.error);
				}
			})
		}.bind(this));

		window.ptvbus.on('logged-in', function (data) {
			this.streamer = data.userid === this.channelID;
			this.hideAds = data.product !== 0;

			riot.mount("private-stream-setup-modal", {
				privateKey: data.private_key,
				private:    data.private,
				motd:       data.private_motd
			});

			this.update();
		}.bind(this));

		window.ptvbus.on('description-edit-mode', function (newState) {
			this.admin_view = !this.admin_view;
			this.update();
			if (this.admin_view) {
				this.adminScroll();
			}
		}.bind(this));

		window.ptvbus.on('update-socials', function (socials) {
			this.homeLink = socials.home || "";
			this.processSocials(socials);
			this.update();
		}.bind(this));

		window.ptvbus.on('private-mode', function(state) {
			this.private = state;
			this.update();
		}.bind(this));
	</script>
</channel-streaminfo>

<channel-streaminfo-viewer>
	<div class="d-block animated-400 fadeIn">
		<div class="stream-info-header bg-light box-shadow p-3 position-relative">
			<div class="d-flex align-items-start mb-2">
				<h4 class="mr-0 mr-lg-2 mb-0">{opts.channelTitle}</h4>
				<span class='ml-auto mr-3 text-muted align-self-center align-items-center d-flex cursor-default' data-i18n="[title]channel.total_views_title" title="Total views">
					<i class="fas fa-chart-area mr-1"></i>
					<span>{opts.totalViews}</span>
				</span>
				<span class='stream-mode align-self-center d-inline-block mb-0 {text-danger: online, text-muted: !online} cursor-default' data-i18n="[title]channel.viewer_title" title="Viewer">
					<i if={online} class='fas fa-eye'></i>
					<span>{online ? viewers : "Offline"}</span>
				</span>
				<!-- Display only on own channel and if clicked user view on admin view -->
				<span class="ml-3" if={opts.streamer}>
					<button class="btn btn-sm btn-sm-block" onclick={switch_view} ref="adminViewBtn">
						<i class="fas fa-cog mr-2"></i>
						<span data-i18n="channel.admin_view">Settings</span>
					</button>
				</span>
				<!-- End -->
			</div>
			<div class="stream-modes-container d-flex align-items-center cursor-default text-muted">
				<span class="cursor-pointer collapsed mr-3" data-i18n="[title]channel.info_title" title="More about the streamer" aria-controls="extras-container" aria-expanded="false" data-toggle="collapse" data-target="#extras-container">
					<i class="text-muted fas fa-address-card mr-1"></i>
					<a onclick="{scroll_to_infos}" href="#" class="font-weight-bold">
						<span data-i18n="channel.info">Info</span>
					</a>
				</span>
				<span class="d-inline-block mr-3" data-i18n="[title]channel.community_title" title="Community">
					<a target="_blank" href="/communities/explore/{opts.community}/{opts.communityName}" class="font-weight-bold">
						<i class='fas fa-fw fa-users text-muted'></i>
						<span>{this.communityNameTranslated}</span>
					</a>
				</span>
				<span class='stream-mode d-inline-block mr-3 streamer_private' data-user-id='' if={opts.private}>
					<i class='fas fa-lock fontSize0-8'></i>
					<span class="" data-i18n='channel.state.private'>Private Stream</span>
				</span>
				<span class='stream-mode d-inline-block mr-3 streamer_adultstream' data-user-id='' if={opts.mature}>
					<i class='fas fa-exclamation-circle fontSize0-8'></i>
					<span class="" data-i18n='channel.state.mature'>Mature Content</span>
				</span>
				<span class='stream-mode d-inline-block mr-3 streamer_gamemode' data-user-id='' if={opts.gamemode}>
					<i class='fas fa-gamepad fontSize0-8'></i>
					<span class="" data-i18n='channel.state.gaming'>Game Mode</span>
				</span>
				<span class='stream-mode d-inline-block mr-3 streamer_commissions' data-user-id='' if={opts.commissions}>
					<i class='fas fa-paint-brush fontSize0-8'></i>
					<span class="" data-i18n=''>Commissions Open</span>
				</span>
	
				<span class="dropdown ml-auto">
					<a href="#" class="dropdown-toggle hide-toggle cursor-pointer" id="social-share-dropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
						<i class='fas fa-fw fa-share-square fontSize0-8'></i>
						<span class="font-weight-bold" data-i18n="channel.share">Share</span>
					</a>
					<div class="dropdown-menu dropdown-menu-right" aria-labelledby="social-share-dropdown">
						<a class="dropdown-item d-flex align-items-center" href="#" onclick="window.open('https://www.facebook.com/sharer/sharer.php?u='+encodeURIComponent(document.URL),'_blank','width=640, height=640'); return false;">
							<i class="fab fa-fw fa-facebook mr-1" style="color: #3b5998"></i>
							<span class="mr-2">Facebook</span>
							<i class="far fa-arrow-right text-muted fontSize0-5 ml-auto"></i>
						</a>
						<a class="dropdown-item d-flex align-items-center" href="#" onclick="window.open('https://www.tumblr.com/widgets/share/tool?canonicalUrl='+encodeURIComponent(document.URL),'_blank','width=640, height=640'); return false;">
							<i class="fab fa-fw fa-tumblr mr-1" style="color: #35465c"></i>
							<span class="mr-2">Tumblr</span>
							<i class="far fa-arrow-right text-muted fontSize0-5 ml-auto"></i>
						</a>
						<a class="dropdown-item d-flex align-items-center" href="#" onclick="window.open('https://twitter.com/home?status='+encodeURIComponent(document.title.replace(/^\(\d+\+?\) /, '')+' https://picarto.tv/{opts.channel} @picartotv'),'_blank','width=640, height=640'); return false;">
							<i class="fab fa-fw fa-twitter mr-1" style="color: #00aced"></i>
							<span class="mr-2">Twitter</span>
							<i class="far fa-arrow-right text-muted fontSize0-5 ml-auto"></i>
						</a>
					</div>
				</span>
			</div>
		</div>
		<!-- Streamer info extras start -->
		<div id="extras-container" class="collapse">
			<div class="d-flex flex-column py-3 px-3 bg-light position-relative">
				<div class="d-flex align-items-center mb-2">
					<div class="extras-name text-muted mr-3" data-i18n="channel.socials.trigger" if={can_show_socials()}>Socials</div>
					<div class="social-container">
							<a if={opts.homeLink} href="/site/referrer?go={encodeURIComponent(opts.homeLink)}&ref={encodeURIComponent(window.location.href)}" target="_blank">
								<i class="fas fa-home my-2 mr-2"></i>
							</a>
							<a each={data in opts.socialLinks} if={data.href} href="/site/referrer?go={encodeURIComponent(data.href)}&ref={encodeURIComponent(window.location.href)}" target="_blank">
								<i class="fab fa-{data.icon} mr-2"></i>
							</a>
					</div>
				</div>
				<div class="d-flex align-items-center mb-2">
					<div class="extras-name text-muted mr-3" data-i18n="channel.tags">Tags</div>
					<div class="tag-container">
						<span each={tag in opts.channelTags} class='d-inline-block mr-2 mb-1'>#{tag}</span>
					</div>
				</div>

				<div class="d-flex align-items-center mb-2">
					<div class="extras-name text-muted mr-3" data-i18n="channel.tool">Tool</div>
					<div class="tool-container">
						<span class="setting">{opts.tablet}</span>
					</div>
				</div>

				<div class="d-flex align-items-center mb-2">
					<div class="extras-name text-muted mr-3" data-i18n="channel.software">Software</div>
					<div class="software-container">
						<span class="setting">{opts.softwareName}</span>
					</div>
				</div>

				<div class="d-flex align-items-center mb-2">
					<div class="extras-name text-muted mr-3" data-i18n="channel.language">Language</div>
					<div class="language-container">
						<span>{this.languageName}</span>
					</div>
				</div>
			</div>
			<div class="text-center text-muted p-1 bg-secondary cursor-pointer" aria-controls="extras-container" aria-expanded="true" data-toggle="collapse" data-target="#extras-container">
				<span data-i18n="channel.close" class="text-uppercase">Close</span>
			</div>
		</div>
		<!-- Description start -->
		<div class="channel-info-container d-block p-3" if={opts.product !== 0 && (opts.panel1 || opts.panel2)}>
			<!-- Custom Banner if premium or basic -->
			<div class="row justify-content-center mt-1 mx-0 overflow-hidden">
				<channel-banner-view if={opts.panel1} channel={opts.channel} banner-id="1" enabled={opts.panel1} uri={opts.panel1Link}/>
				<channel-banner-view if={opts.panel2} channel={opts.channel} banner-id="2" enabled={opts.panel2} uri={opts.panel2Link}/>
			</div>
			<!-- ENDE Banner -->
		</div>
		<!-- Technically should be description-panels-live-view, but event listeners and weird refs -->
		<div class="mt-3 px-3">
			<description-panels panels={opts.descPanels.panels} columns={opts.descPanels.columns} can_edit={false} standalone={false} />
		</div>
	</div>

	<script>
		this.online = opts.online;
		this.viewers = opts.viewers;
		this.showPopover = !localStorage.getItem("adminShown");
		this.communityNameTranslated = i18n("explore.communities."+opts.communityName.replace(/\W/g, '').toLowerCase());
		var languageName = opts.languageName || "";
		this.languageName = i18n("explore.language_list."+languageName.toLowerCase()) || "";

		can_show_socials() {
			return opts.homeLink || Object.keys(opts.socialLinks).find(function(social) {
				return opts.socialLinks[social].href !== "";
			});
		}

		scroll_to_infos(){
			var container = document.querySelector('#player-container');
			var scrollState = container.scrollTop;
			if (!$("#extras-container").hasClass("show") && scrollState < 50){
				var animationDuration = 400;
				var lastFrame = 0;
				var currTime = 0;

				// Old browser fallback, target ~30fps
				var requestFrame = window.requestAnimationFrame || function(cb) {setTimeout(function() {cb((new Date).getTime())}, 33);}

				function runScrollAnimation(timestamp) {
					if (lastFrame !== 0) {
						currTime += timestamp - lastFrame;
					}

					lastFrame = timestamp;

					if (currTime < animationDuration) {
						requestFrame(runScrollAnimation);
					} else {
						currTime = animationDuration;
					}
					
					
					var x = currTime/animationDuration;
					// EaseOutQuart
					var y = (1-Math.pow(x-1, 4));

					// Allow the scroll to be overridden if you scroll down further
					container.scrollTop = Math.max(container.scrollTop, y * 240);
				}

				requestFrame(runScrollAnimation);
			}
		}

		switch_view() {
			if (this.showPopover) {
				$(this.refs["adminViewBtn"]).popover('hide');
				localStorage.setItem("adminShown", true);
			}
			window.ptvbus.trigger('description-edit-mode', true);
		}

		window.ptvbus.on('hide-all-popovers', function() {
			if (this.showPopover) {
				$(this.refs["adminViewBtn"]).popover('hide');
			}
		}.bind(this));

		window.ptvbus.on('channel-live', function(data) {
			if (data.id === opts.channelId) {
				this.online = data.live;
				this.update();
			}
		}.bind(this));

		window.ptvbus.on('viewer-count', function(count) {
			this.viewers = count;
			this.update();
		}.bind(this));

		this.on('mount', function() {
			if (this.showPopover) {
				var elem = $(this.refs["adminViewBtn"]);
				elem.popover({
					placement: "top",
					trigger: "manual",
					content: "Manage your channel here"
				});
				setTimeout(elem.popover.bind(elem, 'show'), 500);
			}
		});
	</script>
</channel-streaminfo-viewer>

<channel-streaminfo-admin>
	<div class="p-3 animated-400 fadeIn bg-light">
		<div class="mb-3 d-flex align-items-center">
			<div class="input-group input-group-sm">
				<input type="text" placeholder="Stream Title" class="form-control {animateAll: streamTitleAnim === 0, bg-success: streamTitleAnim === 1, bg-danger: streamTitleAnim === 2}" value="{opts.channelTitle}" ref="streamTitle" onchange={update_stream_title}>
			</div>
			<span class="dropdown channel-color-switcher ml-2">
				<button class="btn btn-sm dropdown-toggle hide-toggle" data-i18n="channel.channel_color" data-toggle="dropdown">Channel Color</button>
				<div class="dropdown-menu dropdown-menu-right">
					<div class="p-3">
						<virtual if={opts.product != 0}>
							<div class="d-flex flex-wrap align-items-center justify-content-between w-100">
								<span each={color in channelColors} class="channel-color-swatch" style="background-color: #{color};" onclick={set_channel_color.bind(this, color)}><i show={color === selectedChannelColor} class="far fa-check clickThru"></i></span>
							</div>
							<div class="input-group mt-2">
								<div class="input-group-prepend">
									<div class="input-group-text">#</div> <!-- Replace this with an far fa-check if color is set -->
								</div>
								<input type="text" class="form-control form-control-sm" maxlength="6" placeholder="HEX" onchange={set_channel_color_hex} value={selectedChannelColor}>
							</div>
						</virtual>
						<div if={opts.product == 0} class="text-center my-2 w-100 text-dark">
							<h6 class="mb-4" data-i18n="channel.images.tease_head">No Premium yet?</h6>
							<a href="/site/upgrade">
								<button class="btn btn-sm btn-primary text-uppercase"><span data-i18n="menu.upgrade">Upgrade</span><i class="fas fa-chevron-right ml-3"></i></button>
							</a>
						</div>
					</div>
				</div>
			</span>
			<button class="btn btn-sm ml-2" onclick={switch_view}>
				<i class="fas fa-user mr-2"></i>
				<span data-i18n="channel.user_view">User View</span>
			</button>
		</div>
		<div class="d-block d-lg-flex flex-row mb-3 align-items-center">
			<div class="d-block d-lg-flex flex-column mr-0 mr-lg-4">
				<!-- On Private active -->
				<button class="btn btn-block text-left mb-2 {btn-warning: !private}" onclick={show_private}>
					<i class="fas fa-fw {fa-unlock-alt: private, fa-lock: !private} mr-0 mr-lg-1"></i>
					<span show={private} data-i18n="channel.public">Public</span>
					<span hide={private} data-i18n="channel.private">Private</span>
				</button>
				<!-- End -->
				<button class="btn btn-block text-left" data-toggle="modal" data-target="#modal-socials-setup">
						<i class="fas fa-fw fa-share-alt mr-0 mr-lg-1"></i>
						<span data-i18n="channel.socials.trigger">Socials</span>
				</button>
			</div>
			<div class="d-flex flex-column flex-md-row w-100 my-3 my-lg-0 align-items-center">
				<div class="d-flex flex-column mr-3 mr-xl-4">
					<div class="d-flex mb-2">
						<input type="checkbox" class="checkslider checkslider-sm" id="switch-game-mode" onchange={set_gamemode} checked={opts.gamemode}/>
						<label for="switch-game-mode" class="ml-2 verticalTop mb-0 text-muted" data-i18n='channel.state.gaming'>Game Mode</label>
					</div>
					<div class="d-flex mb-2">
						<input type="checkbox" class="checkslider checkslider-sm" id="switch-mature-content" onchange={set_mature} checked={opts.mature}/>
						<label for="switch-mature-content" class="ml-2 verticalTop mb-0 text-muted" data-i18n='channel.state.mature'>Mature Content</label>
					</div>
					<div class="d-flex">
						<input type="checkbox" class="checkslider checkslider-sm" id="switch-commissions-open" onchange={set_commissions} checked={opts.commissions}/>
						<label for="switch-commissions-open" class="ml-2 verticalTop mb-0 text-muted" data-i18n='channel.state.comission'>Commissions Open</label>
					</div>
				</div>
				<div class="d-flex flex-row ml-auto">
					<span class="d-flex flex-column ml-2">
						<button class="btn btn-link btn-block px-0 text-right" onclick={showRaffle}>
							<span data-i18n="channel.overlay.raffle">Chat Raffle</span>
							<i class="fas fa-fw fa-comment-alt-smile mr-1"></i>
						</button>
						<button class="btn btn-link btn-block px-0 text-right" onclick={showPoll}>
							<span data-i18n="channel.overlay.poll">Chat Poll</span>
							<i class="fas fa-fw fa-comment-alt-lines mr-1"></i>
						</button>
					</span>
				</div>
			</div>
		</div>
		<!-- Additional Settings Accordion -->
		<div id="accordion" class="mb-1">
			<!-- Additional Infos -->
			<div class="card mb-1 shadow">
				<div class="card-header cursor-pointer" id="headingOne" aria-controls="stream-control-container" aria-expanded="true" data-toggle="collapse" data-target="#stream-control-container">
					<h6 class="m-0">
						<a data-i18n="channel.additional_info">Additional Information</a>
					</h6>
				</div>
				<div class="collapse show" id="stream-control-container" data-parent="#accordion">
					<div class="card-body">
						<div class="row">
							<div class="d-flex flex-column col-12 col-xl-6 mb-2">
								<div class="mb-1 text-muted" data-i18n="channel.community">Community</div>
								<select class="form-control mb-2" size="1" onchange={update_cat}>
									<option each={cat in opts.communitiesList} class='{select_option: opts.community === cat.id}' value={cat.id} selected={opts.community==cat.id}>
										{i18n("explore.communities."+cat.name.replace(/\W/g, '').toLowerCase())}
									</option>
								</select>
								<div class="mb-1 text-muted" data-i18n="channel.software">Software</div>
								<select class="form-control" size="1" onchange={update_software}>
									<option each={software in opts.softwareList} class='{select_option: opts.software == software.id}' value={software.id} selected={opts.software==software.id}>{software.name}</option>
								</select>
							</div>
							<div class="d-flex flex-column col-12 col-xl-6 mb-2">
								<div class="mb-1 text-muted" data-i18n="channel.language">Language</div>
								<select class="form-control mb-2" size="1" onchange={update_language}>
									<option each={language in opts.languageList} class='{select_option: opts.language == language.id}' value={language.id} selected={opts.language==language.id}>{i18n("explore.language_list."+language.name.toLowerCase())}</option>
								</select>
								<div class="mb-1 text-muted" data-i18n="channel.tool">Tool</div>
								<input type="text" class="form-control" value="{opts.tablet}" onchange={update_tablet}>
							</div>
							<div class="d-flex flex-column col-12">
								<channel-tags-editor channel-tags={opts.channelTags} events={opts.events}/>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- END -->
			<!-- Banners -->
			<div class="card mb-1 shadow">
				<div class="card-header cursor-pointer" id="headingTwo" aria-controls="stream-banner-container" aria-expanded="false" data-toggle="collapse" data-target="#stream-banner-container">
					<h6 class="mb-0">
						<a data-i18n="channel.images.title">Images</a>
					</h6>
				</div>
				<div class="collapse" id="stream-banner-container" data-parent="#accordion">

					<!-- Chat Banner & Offline Image -->
					<div class="card-body">
						<div class="row">
							<div class="col-12 col-lg-6 mb-2" if={opts.product === 1}>
								<h6 class="text-muted" data-i18n="channel.images.offline">Offline Image</h6>
								<dropable-container name={i18n("channel.images.offline")} subtext={i18n("channel.images.1920x1080x512")} img-type="offlineimg" meta={{height: 1080, width: 1920}} bg-image={opts["offlineImage"]? "/user_data/usrimg/"+opts.channel.toLowerCase()+ "/offlineimage.png": ""}/>
							</div>
							<div class="col-12 {col-lg-6: opts.product === 1} mb-2">
								<h6 class="text-muted" data-i18n="channel.images.banner">Chat Banner</h6>
								<dropable-container name={i18n("channel.images.banner")} subtext={i18n("channel.images.410x80x650")} img-type="chatbanner" meta={{height: 80, width: 410}} bg-image={opts["chatBanner"]? "/user_data/usrimg/"+opts.channel.toLowerCase()+ "/panelbanner.gif": ""}/>
							</div>
						</div>
					</div>

					<!-- 2x Premium Banner -->
					<div class="card-body">
						<div class="d-flex flex-column justify-content-center" if={opts.product !== 1}>
							<h6 class="text-muted" data-i18n="channel.images.tease_title">Premium Banner/Offline Image</h6>
							<div class="text-center my-2 w-100">
								<h6 data-i18n="channel.images.tease_head">No Premium yet?</h6>
								<div class="text-muted mb-3" data-i18n="channel.images.tease_body">Upload up to two custom banners with hotlink that will enhance your channel's user experience</div>
								<a href="/site/upgrade">
									<button class="btn btn-sm btn-primary text-uppercase"><span data-i18n="menu.upgrade">Upgrade</span><i class="fas fa-chevron-right ml-3"></i></button>
								</a>
							</div>
						</div>
						<div class="row" if={opts.product === 1}>
							<div class="col-12 col-lg-6 mb-2" each={id in [1,2]}>
								<h6 class="text-muted" data-i18n="channel.images.premium">Premium Banner</h6>
								<dropable-container name={i18n("channel.images.premium")} subtext={i18n("channel.images.855x180x512")} img-type="panel" meta={{id: id, height: 180, width: 855}} bg-image={opts["panel"+id]? "/user_data/usrimg/"+opts.channel.toLowerCase()+ "/panelimage"+id+ ".jpg": ""}/>
								<div class="my-1 text-muted" data-i18n="channel.images.premium_link">Banner Link</div>
								<input class="form-control form-control-sm w-100 mt-1 {animateAll: updateAnims[id] === 0, bg-success: updateAnims[id] === 1, bg-danger: updateAnims[id] === 2}" type="text" name="Banner {id} link" placeholder="Banner link" value={opts[ "panel"+id+ "Link"]} onchange={banner_link_change} data-id={id}>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- END -->
			<!-- Description -->
			<div class="card shadow">
				<div class="card-header cursor-pointer" id="headingThree" aria-controls="stream-description-container" aria-expanded="false" data-toggle="collapse" data-target="#stream-description-container">
					<h6 class="mb-0">
						<a data-i18n="channel.description">Description</a>
					</h6>
				</div>
				<div class="collapse" id="stream-description-container" aria-labelledby="headingThree" data-parent="#accordion">
					<div class="card-body">
						<!-- Technically should be description-panels-edit-view, but event listeners and weird refs -->
						<description-panels panels={opts.descPanels.panels} columns={opts.descPanels.columns} can_edit={true} standalone={false} />
					</div>
				</div>
			</div>
			<!-- END -->
		</div>
	</div>

	<script>
		this.private = opts.private;
		this.updateAnims = {
			1: 0,
			2: 0
		};

		this.streamTitleAnim = 0;
		this.streamTitleUpdating = false;

		this.channelColors = ["1da456", "b2e51b", "e77b00", "1be594", "6688f5", "ad1be5", "e80db1", "c4073a"];
		this.selectedChannelColor = opts.color;

		show_private() {
			if (opts.product != 1) {
				window.location.href = "/site/upgrade";
			} else {
				$("private-stream-setup-modal").modal('show');
			}
		}

		window.ptvbus.on('private-mode', function (state) {
			this.private = state;
			this.update();
		}.bind(this));

		update_software(evt) {
			var selectedValue = evt.target.selectedOptions[0].value;
			opts.events.trigger('update-software', parseInt(selectedValue));
		}

		update_language(evt) {
			var selectedValue = evt.target.selectedOptions[0].value;
			opts.events.trigger('update-language', parseInt(selectedValue));
		}

		update_tablet(evt) {
			this.opts.events.trigger('update-tablet', evt.currentTarget.value);
		}

		update_cat(evt) {
			var selectedValue = evt.target.selectedOptions[0].value;
			opts.events.trigger('update-community', parseInt(selectedValue));
		}

		set_gamemode(evt) {
			window.ptvbus.trigger('set-gamemode', evt.target.checked);
		}

		set_mature(evt) {
			window.ptvbus.trigger('set-mature', evt.target.checked);
		}

		set_commissions(evt) {
			window.ptvbus.trigger('set-commissions', evt.target.checked);
		}

		switch_view() {
			window.ptvbus.trigger('description-edit-mode', false);
		}

		set_channel_color(newColor, evt) {
			this.selectedChannelColor = newColor;
			window.ptvbus.trigger("set-channel-color", this.selectedChannelColor);
		}

		set_channel_color_hex(evt) {
			if (!/^([0-9a-fA-F]{3}){1,2}$/.test(evt.currentTarget.value)) {
				return;
			}

			this.selectedChannelColor = evt.currentTarget.value;
			window.ptvbus.trigger("set-channel-color", this.selectedChannelColor);
		}

		update_stream_title() {
			var title = this.refs["streamTitle"].value;
			if (title.length > 60) {
				this.streamTitleAnim = 2;
				setTimeout(function () {
					this.streamTitleAnim = 0;
					this.update();
				}.bind(this), 5);
				return;
			}

			this.streamTitleUpdating = true;
			opts.events.trigger('update-title', title);
		}

		handle_upload(file, elem) {
			elem.trigger('show-progress');

			$.postForm('/process/image/' + encodeURI(elem.opts.imgType), {
				file: file,
				meta: JSON.stringify(elem.opts.meta)
			},
			null,
			function () {
				var xhr = new window.XMLHttpRequest();
				xhr.upload.addEventListener('progress', function (evt) {
					if (evt.lengthComputable) {
						elem.trigger('progress', evt.loaded / evt.total);
					} else {
						elem.trigger('progress-spin');
					}
				});

				// Some of these may be invalid, I'm not sure
				xhr.upload.addEventListener('loadstart', function () {
					elem.trigger('progress-spin');
				});
				xhr.upload.addEventListener('loadend', function () {
					elem.trigger('progress-spin');
				});
				xhr.upload.addEventListener('error', function () {
					elem.trigger('abort');
				});
				xhr.upload.addEventListener('load', function () {
					elem.trigger('progress-spin');
				});
				xhr.upload.addEventListener('abort', function () {
					elem.trigger('end-upload');
				});
				return xhr;
			}).fail(function (jqxhr) {
				var error = "";
				try {
					error = JSON.parse(jqxhr.responseText).error;
				} catch (e) {
					error = jqxhr.responseText;
				}

				displayErrorMsgCustom(error);
			}).always(function () {
				var uri = "";
				switch (elem.opts.imgType) {
					case "panel":
						opts.events.trigger('panel-image', { id: elem.opts.meta.id, exists: true });
						uri = "/user_data/usrimg/" + opts.channel.toLowerCase() + "/panelimage" + elem.opts.meta.id + ".jpg";
						break;
					case "offlineimg":
						this.opts.events.trigger('player-background', true);
						uri = elem.opts.bgImage;
						window.ptvbus.trigger('set-player-poster', {channel: opts.channel, uri: uri + "?t=" + (new Date).getTime()});
						break;
					case "chatbanner":
						this.opts.events.trigger('chat-banner', true);
						uri = elem.opts.bgImage;
						$("#channel_chatbanner").css('background-image', 'url(' + uri + '?t=' + (new Date).getTime() + ')');
						// TODO: Use ptvbus for this to interact with chat client instead
						$("#channel_chatbanner").show();
						break;
				}
				elem.trigger('update-img', uri);
			}.bind(this));
		}

		handle_delete_banner(elem) {
			elem.trigger('show-progress');

			$.post('/process/channel', { delete_banner: elem.opts.meta.id })
				.done(function () {
					elem.trigger('update-img', "");
					opts.events.trigger('panel-image', { id: elem.opts.meta.id, exists: false });
				})
				.fail(function (jqxhr) {
					elem.trigger('hide-progress');
					var error = "";
					try {
						error = JSON.parse(jqxhr.responseText).error;
					} catch (e) {
						error = jqxhr.responseText;
					}

					displayErrorMsgCustom(error);
				});
		}

		banner_link_change(evt) {
			var id = evt.target.dataset.id;
			var value = evt.target.value;

			if (value !== "") {
				var checkRegex = /^https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?!&\/=]*)$/i;

				if (!checkRegex.test(value)) {
					// Attempt to auto-correct the URL
					value = "http://" + value;
					if (!checkRegex.test(value)) {
						this.updateAnims[id] = 2;
						setTimeout(function () {
							this.updateAnims[id] = 0;
							this.update();
						}.bind(this), 5);
						return;
					} else {
						evt.target.value = value;
					}
				}
			}

			$.post('/process/channel', { banner_link: value, banner_id: id })
				.done(function () {
					this.updateAnims[id] = 1;
					opts.events.trigger('update-banner-link', { id: id, value: value });
				}.bind(this))
				.fail(function () {
					this.updateAnims[id] = 2;
				}.bind(this))
				.always(function () {
					this.update();
					setTimeout(function () {
						this.updateAnims[id] = 0;
						this.update();
					}.bind(this), 5);
				}.bind(this));
		}

		showRaffle() {
			window.socket.Emit('NewMessage', new proto.NewMessage(['/r']));
		}

		showPoll() {
			// We COULD do this inline, but better to keep stuff centeralised.
			window.socket.Emit('NewMessage', new proto.NewMessage(['/p']));
		}

		descScroll() {
			var scrolling = true;
			setTimeout(function(){scrolling = false;}, 500);

			var queueScroll;

			var runScroll = function() {
				if (scrolling) {
					queueScroll(runScroll);
				}
				this.refs["descScrollTarget"].scrollIntoView({behavior: "instant", block: "start", inline: "start"});
			}.bind(this);

			if (requestAnimationFrame) {
				queueScroll = requestAnimationFrame;
			} else {
				// A lot more jittery (~30fps) but it works
				queueScroll = function(cb) {
					setTimeout(cb, 33);
				};
			}

			queueScroll(runScroll);
		}

		this.on('mount', function () {
			var containers = this.tags["dropable-container"];

			var self = this;

			if (!Array.isArray(containers)) {
				containers = [containers];
			}

			containers.forEach(function (elem) {
				elem.on('upload', function (file) {
					if (elem.opts.imgType === "chatbanner" && file.type === "image/gif") {
						return self.handle_upload(file, elem);
					}

					window.ptvbus.trigger('crop-image', {
						imgSrc:       file,
						height:       elem.opts.meta.height,
						width:        elem.opts.meta.width,
						rounded:      false,
						bgClass:      "bg-light",
						mime:		  "image/jpeg",
						cropCallback: function(data, blob, done) {
							done();
							self.handle_upload(blob, elem);
						}
					});
				});

				elem.on('delete', function () {
					switch (elem.opts.imgType) {
						case "panel":
							self.handle_delete_banner(elem);
							break;
						case "offlineimg":
							$.post('/process/settings/imagerecords', {type: 'imgrm', rmimgtype: "offlineimg"}).always(function() {
								this.opts.events.trigger('player-background', false);
								window.ptvbus.trigger('set-player-poster', {channel: opts.channel, uri: "/user_default/offlineimage.jpg"});
								elem.trigger('update-img', "");
							}.bind(this));
							break;
						case "chatbanner":
							$.post('/process/settings/imagerecords', {type: 'imgrm', rmimgtype: "chatbanner"}).always(function() {
								this.opts.events.trigger('chat-banner', false);
								elem.trigger('update-img', "");
								// TODO: Use ptvbus for this to interact with chat client instead
								$("#channel_chatbanner").hide();
							}.bind(this));
							break;
						default:
							console.warn("Delete not implemented for type " + elem.opts.imgType);
					}
				}.bind(this));
			}.bind(this));

			this.opts.events.on('update-title-response', function (success) {
				this.streamTitleUpdating = false;
				this.streamTitleAnim = success ? 1 : 2;
				this.update();
				setTimeout(function () {
					this.streamTitleAnim = 0;
					this.update();
				}.bind(this), 5);
			}.bind(this));
		});
	</script>
</channel-streaminfo-admin>

<channel-banner-view class="col-6 d-block p-0">
	<div class="prembannerholder m-0" if={opts.enabled}>
		<a target='_blank' href={getURI()} rel='nofollow noopener noreferrer'>
			<img class='channel-banner box-shadow' src='/user_data/usrimg/{opts.channel.toLowerCase()}/panelimage{opts.bannerId}.jpg' />
		</a>
	</div>

	<script>
		getURI() {
			if (opts.uri) {
				return "/site/referrer?go=" + encodeURIComponent(opts.uri) + "&ref=" + encodeURIComponent(window.location.href);
			} else {
				return "";
			}
		}
	</script>
</channel-banner-view>

<channel-tags-editor>
	<div class="mb-1 text-muted" data-i18n="channel.tags">Tags</div>
	<ul ref="tagContainer" class="mb-0 fontSize0-8 form-control position-relative border-0 bg-secondary">
		<li each={tag in channelTags}>{tag}</li>
	</ul>

	<script>
		this.channelTags = opts.channelTags.slice();

		var updateTags = function (evt) {
			var tags = $(this.refs["tagContainer"]).tagit("assignedTags");

			this.opts.events.trigger('update-tags', tags.join(","));
		}.bind(this);

		this.on('mount', function () {
			$(this.refs["tagContainer"]).tagit({
				singleField: true,
				tagLimit: 15,
                beforeTagAdded: function(event, ui) {
                    const patt = /^([\w\d]{2,15})$/g;
                    let tag = ui.tag.text().slice(0, -1);
                    return patt.test(tag);
                }
			});

			// We could do this on tag add/remove, but this is a more reliable debounce trigger
			this.root.querySelector(".tagit-new input").addEventListener('blur', updateTags);
		});
	</script>
</channel-tags-editor>