<description-panels>
	<virtual if={ opts.can_edit && opts.standalone }>
		<div class={ clearfix: !editing }>
			<div class="flex">
				<div style="flex-grow: 1;"></div>
				<label class="panelSwitch"><span data-i18n="channel.description_editor.edit">Edit panels</span><input type="checkbox" class="checkslider" onchange={ switchmode } checked={ editing }></label>
			</div>
			<br hide={ editing }>
		</div>
	</virtual>
	<description-panel-live-view hide={ editing } panels={ panels } columns={ columns }/>
	<description-panel-edit-view show={ editing } panels={ panels } columns={ columns } if={ opts.can_edit }/>

	<script>
		this.panels = opts.panels || [];
		this.columns = opts.columns || 4;

		if (!this.panels.on) {
			riot.observable(this.panels);
		}
		// Edit mode
		this.editing = opts.can_edit && !opts.standalone;

		try {
			this.mixin('panel_metadata');
		} catch(e) {
			// Fallback
			this.getChannelID = this.getUserID = function() {return -1;};
			this.getChannelName = this.getUserDisplayName = function() {return "";};
		}

		window.ptvbus.on('description-edit-mode', function(editing) {
			this.editing = editing;
			this.update();
		}.bind(this));

		window.ptvbus.on('logged-in', function(data) {
			this.getUserID = function() {return data.userid;};
			this.getUserDisplayName = function() {return data.channel_name;};

			opts.can_edit = data.userid === this.getChannelID();
			this.update();
		}.bind(this));

		window.ptvbus.on('description-update', function(data) {
			// WARNING: This will keep references of objects. It will mean we use less memory, BUT it will also mean changes modify all panels
			this.panels = data.panels;
			this.columns = data.columns;
			this.update();
		}.bind(this));

		switchmode(e) {
			this.editing = e.target.checked;
			if (!this.editing) {
				// Will update for us
				window.ptvbus.trigger('description-update', {
					panels: this.panels,
					columns: this.columns
				});
			}
		}

		this.panels.on('set-columns', function(columns) {
			this.columns = columns;
			window.ptvbus.trigger('description-update', {
				panels: this.panels,
				columns: this.columns
			});
		}.bind(this));
	</script>
</description-panels>

<description-panel-live-view>
	<description-panel each={ opts.panels } panel={ this } editing={ false } if={ !hidden } columns={ parent.opts.columns }/>

	<script>
		var self = this;
		this.masonry = null;
		this.masonryDebounced = debounce(function() {
			if (self.masonry) {
				self.masonry.layout();
			}
		}, 100);

		this.on('mount', function() {
			// Force loading/injecting masonry if it was not loaded for some reason
			if (typeof window.Masonry == "undefined") {
				var s = document.createElement('script');
				s.type = "text/javascript"
				s.src = "/js/masonry/masonry.min.js";
				s.onload = this.initMasonry;
				document.head.appendChild(s);
			} else {
				this.initMasonry();
			}
		});

		this.opts.panels.on('masonry-relayout', function() {
			self.masonryDebounced();
		});

		initMasonry() {
			// To disable animation, set transitionDuration: 0
			this.masonry = new Masonry("description-panel-live-view", {
				itemSelector: "description-panel",
				percentPosition: true,
				transitionDuration: 0 // Default is '0.4s' or 400
			});

			var self = this;
			this.masonry.on('layoutComplete', function() {
				self.opts.panels.trigger('masonry-layout');
			});
		}

		this.on('updated', function() {
			if (this.masonry) {
				this.masonry.reloadItems();
				this.masonry.layout();
			}
		});
	</script>
</description-panel-live-view>

<description-panel-edit-view>
	<span class="text-muted" data-i18n="channel.description_editor.columns">Columns:</span><span class="p-1"></span>
	<virtual each={ column in [2, 3, 4] }>
		<button class="btn { Blank: opts.columns !== column, btn-primary: opts.columns === column }" onclick={ set_columns } column={ column }>{ column }</button>
	</virtual>
	<div>&nbsp;</div>
	<h6 class="mb-2 text-muted" data-i18n="channel.description_editor.drag_drop">Drag & Drop to reorder</h6>
	<description-panel-edit-list panels={ opts.panels }/>
	<description-panel-edit-wrapper if={ active }>
		<div style="flex-grow: 1;"></div>
		<div data-role="description-panel-editor" class="">
			<h5 class="text-center mb-2" data-i18n="channel.description_editor.panel_editor">Panel Editor</h5>
			<description-panel-editor panel={ this.active } panels={ opts.panels }/>
		</div>
		<div class="my-2 cutLine2" data-role="separator-tall">&nbsp;</div>
		<div class="text-center d-flex" data-role="separator">
			<div style="flex-grow: 1;"></div>
			<div class="verticalRule"></div>
			<div style="flex-grow: 1;"></div>
		</div>
		<div data-role="description-panel">
			<h5 class="text-center mb-2" data-i18n="channel.description_editor.panel_preview">Panel Preview</h5>
			<description-panel panel={ this.active } editing={ true }/>
		</div>
		<div style="flex-grow: 1;"></div>
	</description-panel-edit-wrapper>

	<style>
		description-panel-edit-wrapper {
			display: flex;
		}

		div[data-role="description-panel-editor"], div[data-role="description-panel"] {
			height: 100%;
			width: 100%;
			max-width: 400px;
			flex-grow: 1;
			margin: 0;
		}

		div[data-role=separator] {
			width: 125px;
			flex-direction: column;
		}
		div[data-role="separator-tall"] {
			display: none;
		}

		/* Mobile view */
		@media (max-width: 767px) {
			description-panel-edit-wrapper {
				flex-direction: column;
			}
			div[data-role="separator"] {
				display: none;
			}
			div[data-role="separator-tall"] {
				display: initial;
			}
			div[data-role="description-panel-editor"] {
				padding-bottom: 20px;
			}
			div[data-role="description-panel-editor"], div[data-role="description-panel"] {
				max-width: unset;
			}
		}

		input[type=number] {
			display: inline-block;
			/*width: 200px;*/
			width: 1.3em;

			/* Cross-browser styling */
			-moz-appearance: textfield;
		}

		/* Cross-browser styling */
		input[type=number]::-webkit-inner-spin-button, 
		input[type=number]::-webkit-outer-spin-button { 
			-webkit-appearance: none;
			margin: 0; /* Removes leftover margin */
		}
	</style>

	<script>
		var self = this;
		this.active = null;

		var post_column_count = debounce.call(this, function(cols) {
			$.post("/process/panels", {
				type: "columns",
				columns: cols
			});
		}, 500, true);

		opts.panels.on('set-active', function(elem) {
			for (var i = 0; i < opts.panels.length; ++i) {
				opts.panels[i].active = opts.panels[i] === elem;
			}
			self.active = elem;
			self.update();
		});

		opts.panels.on('refresh-preview', function() {
			self.update();
		});

		opts.panels.on('remove', function(elem) {
			var index = opts.panels.indexOf(elem);

			opts.panels.splice(index, 1);

			var toActivate = index;

			if (toActivate === opts.panels.length)
				toActivate--;
			
			opts.panels.trigger('set-active', opts.panels[toActivate]);
		});

		set_columns(e) {
			var cols = e.item.column;

			opts.panels.trigger('set-columns', cols);

			// TODO: Handle submission via XHR

			post_column_count(cols);
		}

		// Initial value
		if (opts.panels.length > 0)
			opts.panels.trigger('set-active', opts.panels[0]);

	</script>
</description-panel-edit-view>

<description-panel-edit-list>
	<button onclick={ add } class="btn btn-lg  box-shadow" disabled={ opts.panels.length >= 50 }><i class="fas fa-plus fontSize3 { text-primary: opts.panels.length < 50, text-muted: opts.panels.length >= 50 }"></i></button>
	<div each={ opts.panels } style={ getPanelImage(id) } class="panelBorder round-corners bg-dark { border-primary: active, borderBG1: !active }" onclick={ setactive } draggable=true ondragstart={ dragstart } ondragend={ dragend } drop={ dragend } ondragenter={ dragenter } ondragover={ dragover }>
		<div class="position-absolute panelHidden bg-dark" show={ hidden }></div>
		<div class="position-absolute flex" style="flex-direction: column;" show={ hidden }>
		<div class="text-center"><i class="fas fa-eye-slash fontSize3"></i></div>
		</div>
		<span class="bottom bg-dark text-white fontSize0-8" show={ title }>{ title }</span>
	</div>

	<script>
		var self = this;
		this.isNotIE = navigator.userAgent.indexOf(" Trident/") === -1 && navigator.userAgent.indexOf(" Edge/") === -1;

		try {
			this.mixin('panel_metadata');
		} catch(e) {
			// Fallback
			this.getChannelID = this.getUserID = function() {return -1;};
			this.getChannelName = this.getUserDisplayName = function() {return "";};
		}

		getPanelImage(panelID) {
			var panel = opts.panels.find(function(e) {
				return e.id === panelID
			});
			if (panel && panel.image_hash.length)
				return "background-image: url(/user_data/usrimg/" + this.getChannelName().toLowerCase() + "/panels/" + panel.id + "_" + panel.image_hash +".png)";
			else
				return "";
		}

		add() {
			if (opts.panels.length >= 50) {
				displayNotificationMsgImportant(98);
				return;
			}
			var panel = {
				id: -1,
				title: "Panel " + (opts.panels.length + 1),
				image_hash: "",
				url: "",
				body: "",
				button: null,
				hidden: false,
				active: false
			};
			opts.panels.push(panel);
			opts.panels.trigger('set-active', panel);

			// Can add all properties, but unneeded ones can be excluded
			$.post("/process/panels", {
				type: "add",
				title: panel.title,
				visible: !panel.hidden
				
			}).done(function(body) {
				var id = parseInt(body);
				if (isNaN(id)) {
					opts.panels.trigger('remove', panel);
					return;
				}

				panel.id = id;
			}).error(function() {
				opts.panels.trigger('remove', panel);
			});
		}

		setactive(e) {
			opts.panels.trigger('set-active', e.item);
		}

		var dragData = null;
		var dragElem = null;

		// REWORK ALL OF THIS FOR REDUX TO PERSIST NEW ITEM PLACEMENT
		dragstart(e) {
			// Because firefox
			e.dataTransfer.setData('text/plain', '');
			dragData = e.item;
			dragElem = e.target;
			dragElem.style.opacity = 0.5;
		}

		dragend(e) {
			if (dragData != null) {
				dragElem.style.opacity = '';
				$.post("/process/panels", {
					type: "move",
					desc_id: dragData.id,
					new_pos: opts.panels.indexOf(dragData)
				});

				dragData = null;
				dragElem = null;
			}
		}

		// So apparantly we can't use dragover because it breaks in firefox. Dragenter it is!
		dragenter(e) {
			if (!dragData) return;
			e.preventDefault();
			if (e.item != dragData) {
				var newIndex = opts.panels.indexOf(e.item);
				var ourIndex = opts.panels.indexOf(dragData);
				opts.panels.splice(newIndex, 0, opts.panels.splice(ourIndex, 1)[0]);
			}
		}

		// Firefox, what are you doing
		dragover(e) {
			if (dragData)
				e.preventDefault();
		}
	</script>
</description-panel-edit-list>

<description-panel-editor class="bg-light p-3 round-corners">
	</div><label class="panelSwitch"><span data-i18n="channel.description_editor.hide_panel">Hide panel</span> <input type="checkbox" class="checkslider" checked={ opts.panel.hidden } onchange={ toggleHidden }></label></div>
	<description-panel-image-upload panel={ opts.panel }/>
	<input class="form-control mt-2" maxlength="2038" placeholder="Image link URL" value={ opts.panel.url } onchange={ updateURL } data-i18n="[placeholder]channel.description_editor.image_link">
	<input class="form-control mt-4" maxlength="21" placeholder="Panel title" value={ opts.panel.title } onchange={ updateTitle } onkeyup={ updateTitle } onkeyup={ updateTitle } data-i18n="[placeholder]channel.description_editor.panel_title">
	<textarea class="form-control" ref="body" maxlength="10000" placeholder="Type in here about your commission details, chat rules or general info about yourself! With our markdown tutorial below you can style your text in many ways." onchange={ updateBody } onkeydown={ updateBody } onkeyup={ updateBody } data-i18n="[placeholder]channel.description_editor.panel_description">{ opts.panel.body }</textarea>
	<div class="d-flex text-muted mb-3">
		<div class="text-left"><a href="/site/markdown" target="_blank"><i class="fas fa-fw fa-info-circle miniIcon"></i> Markdown</a></div>
		<div class="text-right">{ charsUsed }/10000</div>
	</div>
	<label class="panelSwitch"><span data-i18n="channel.description_editor.add_button">Add button</span> <input type="checkbox" class="checkslider" checked={ opts.panel.button ? 1 : 0 } onchange={ toggleButton }></label>
	<virtual if={ opts.panel.button }>
		<input class="form-control" maxlength="21" placeholder="Button text" value={ opts.panel.button.text } onchange={ updateButtonText } onkeydown={ updateButtonText } onkeyup={ updateButtonText } data-i18n="[placeholder]channel.description_editor.button_text">
		<input class="form-control" maxlength="2038" placeholder="Button URL/email" value={ opts.panel.button.url } onchange={ updateButtonURL } data-i18n="[placeholder]channel.description_editor.button_url">
	</virtual>
	<br hide={ opts.panel.button }>
	<description-panel-confirm-remove/>

	<script>
		this.charsUsed = opts.panel.body.length;
		var self = this;

		var post_update_panel = function() {
			var to_debounce = function(panel) {
				var data = {
					type: "update",
					desc_id: panel.id,
					title: panel.title,
					body: panel.body,
					url: panel.url,
					button_enabled: panel.button !== null ? 1 : 0,
					button_text: "",
					button_url: "",
					visible: !panel.hidden ? 1 : 0
				};

				if (panel.button !== null) {
					data.button_text = panel.button.text;
					data.button_url = panel.button.url;
				}
				$.post("/process/panels", data);
			};
			
			var last_id = self.opts.panel.id;
			var debounced = debounce.call(self, to_debounce, 750, true);

			return function(panel) {
				if (last_id !== panel.id) {
					last_id = panel.id;
					debounced = debounce.call(self, to_debounce, 750, true);
				}

				debounced(panel);
			};
		}();

		// Get a getter in the form of a closure
		function bindValue(object) {
			var args = arguments;

			var bind_evt = function(e) {
				var target = object;
				var property = args[args.length-1];

				for (var i = 1; i < args.length-1; ++i) {
					target = target[args[i]];
				}

				if (e.target.type === "checkbox")
					target[property] = e.target.checked;
				else if (e.target.type === "text" || e.target.type === "textarea")
					target[property] = e.target.value;
				else
					return; // Unknown type
				
				opts.panels.trigger('refresh-preview');
				post_update_panel(self.opts.panel);
			};
			var bind_evt_debounced = debounce(bind_evt);
			var lastDebounceID = self.opts.panel.id;

			return function(e) {
				// Create new debounce instance in the case of changing panels if required
				if (lastDebounceID !== self.opts.panel.id) {
					lastDebounceID = self.opts.panel.id;
					bind_evt_debounced = debounce(bind_evt);
				}

				// Resolve the target + property
				if (e.type === 'keydown' || e.type === 'keyup')
					bind_evt_debounced.call(this, e);
				else
					bind_evt(e);
			};
		}

		// Toggle the visibility of the button
		toggleButton(e) {
			if (e.target.checked)
				opts.panel.button = {
					text: "",
					url: ""
				};
			else
				opts.panel.button = null;
			opts.panels.trigger('refresh-preview');
			post_update_panel();
		}

		// Bind checkboxes/text inputs/textareas to properties
		this.toggleHidden = bindValue(opts, "panel", "hidden");
		this.updateURL = bindValue(opts, "panel", "url");
		this.updateTitle = bindValue(opts, "panel", "title");
		this.updateButtonText = bindValue(opts, "panel", "button", "text");
		this.updateButtonURL = bindValue(opts, "panel", "button", "url");

		var updateBodyBind = bindValue(opts, "panel", "body");
		updateBody(e) {
			updateBodyBind.apply(this, Array.prototype.slice.call(arguments));
			this.update(); // Refresh character counter
		}

		remove(e) {
			var id = opts.panel.id;
			opts.panels.trigger('remove', opts.panel);
			$.post("/process/panels", {
				type: "remove",
				desc_id: id
			});
		}

		var currID = opts.panel.id;
		this.on('update', function() {
			if (opts.panel.id != currID) {
				this.charsUsed = opts.panel.body.length;
				this.trigger('remove-reset');
			} else {
				this.charsUsed = this.refs.body.value.length;
			}
			
			currID = opts.panel.id;
		});

		this.on('remove-confirmed', this.remove);
	</script>
</description-panel-editor>

<description-panel-confirm-remove>
	<button class="btn btn-link px-0 text-left" onclick={ clicked } ref="main" hide={ active } data-i18n="channel.description_editor.remove">Remove</button>
	<span show={ active }>
		<button class="btn btn-sm btn-danger removeConfirm" onclick={ confirmed }><i class="fas fa-fw fa-check clickThru"></i></button>
		<button class="btn btn-sm removeCancel" onclick={ cancelled }><i class="fas fa-fw fa-times clickThru"></i></button>
	</span>

	<script>
		this.active = false;

		clicked() {
			this.active = true;
		}

		confirmed() {
			this.parent.trigger('remove-confirmed');
			this.active = false;
		}

		cancelled() {
			this.active = false;
		}

		this.on('mount', function() {
			var self = this;

			this.parent.on('remove-reset', function() {
				self.active = false;
			});
		});
	</script>
</description-panel-confirm-remove>

<description-panel-image-upload class="round-corners">
	<dropable-container name="panel image" subtext="Optimal size 780x360 pixels" bg-image={getFile()}/>

	<script>
		this.container = null;
		this.currPanelID = opts.panel.id;

		try {
			this.mixin('panel_metadata');
		} catch(e) {
			// Fallback
			this.getChannelID = this.getUserID = function() {return -1;};
			this.getChannelName = this.getUserDisplayName = function() {return "";};
		}

		var dragCount = 0;

		this.on('mount', function() {
			var self = this;
			this.container = this.tags["dropable-container"];

			this.container.on('upload', function(file) {
				window.ptvbus.trigger('crop-image', {
					imgSrc:       file,
					height:       360,
					width:        780,
					rounded:      false,
					bgClass:      "bg-dark",
					mime:         "image/jpeg",
					cropCallback: function(data, blob, done) {
						done();
						window.b = blob;
						window.d = data;
						self.handleFile(blob);
					}
				});
			});

			this.container.on('delete', this.deleteimage);
		});

		this.on('update', function() {
			if (opts.panel.id !== this.currPanelID) {
				this.currPanelID = opts.panel.id;
				this.container.trigger('update-img', this.getFile());
			}
		});

		getFile() {
			if (opts.panel.image_hash) {
				return "/user_data/usrimg/" + this.getChannelName().toLowerCase() + "/panels/" + opts.panel.id + "_" + opts.panel.image_hash + ".png";
			} else {
				return false;
			}
		}

		deleteimage() {
			this.opts.panel.image_hash = "";
			this.container.trigger('update-img', this.getFile());
			this.parent.opts.panels.trigger('refresh-preview');
			$.post("/process/panels", {
				type: "removeimg",
				desc_id: this.opts.panel.id
			});
		}

		handleFile(file) {
			var self = this;

			self.container.trigger('progress-spin');

			$.postForm("/process/image/descpanel", {
				type: "img",
				desc_id: this.opts.panel.id,
				file: file
			}).done(function(body) {
				try {
					var data = JSON.parse(body);
					if (data.status === "error") {
						displayErrorMsgCustom(data.error);
					}
				} catch(e) {
					displayErrorMsgCustom(body);
				}

				self.opts.panel.image_hash = data.hash;
				self.container.trigger('update-img', self.getFile());
				self.update();
				self.parent.opts.panels.trigger('refresh-preview');
			}).fail(function(jqxhr) {
				try {
					var data = JSON.parse(jqxhr.responseText);
					displayErrorMsgCustom(data.error);
				} catch(e) {
					displayErrorMsgCustom(jqxhr.responseText);
				}
				self.container.trigger('hide-progress');
			});
		}
	</script>
</description-panel-image-upload>

<description-panel>
	<a class="desc-image-link position-relative" href={ panelURL } if={ opts.panel.image_hash } target="_blank">
		<i class="desc-link-icon fas fa-link" if={ panelURL }></i>
		<img class="panel-image-container round-corners box-shadow mb-2" ref="poster" src="/user_data/usrimg/{this.getChannelName().toLowerCase()}/panels/{opts.panel.id}_{opts.panel.image_hash}.png">
	</a>
	<h4 class="mb-2" if={ opts.panel.title }>{ opts.panel.title }</h4>
	<div class="position-relative text-muted" hide={ this.imageOnly }>
		<markdown class="mb-2 animateAll" ref="body" content={ opts.panel.body }/>
	</div>

	<!--  Expand cover  -->
	<div class="flex" onclick={ expand } if={ canExpand }>
		<div class="flex-line cutLine1"></div>
		<div>{ expanded ? "CLOSE" : "READ MORE" }</div>
		<div class="flex-line cutLine1"></div>
	</div>

	<span class="text-muted d-block" if={ opts.panel.button && (opts.panel.button.url || opts.editing) } data-panel-button>
		<button class="btn btn-md { Green: opts.panel.button.url, disabled: !opts.panel.button.url }" if={ opts.editing || opts.panel.button.url } onclick={ openurl }><i class="buttonIcon fab fa-fw { buttonIcon }" show={ buttonIcon }></i>{ opts.panel.button.text || "Click me" }</button>
		<div class="text-danger" hide={ opts.panel.button.url } if={ opts.editing }><small><strong>Please add a URL/email</strong></small></div>
	</span>

	<script>
		var self = this;
		this.panelURL = opts.panel.url ? "/site/referrer?go=" + encodeURIComponent(opts.panel.url) + "&ref=" + encodeURIComponent(window.location.href) : "";
		this.canExpand = false;
		this.expanded = false;
		this.imageOnly = opts.panel.image_hash && !opts.panel.title && !opts.panel.body && !opts.panel.button;

		try {
			this.mixin('panel_metadata');
		} catch(e) {
			// Fallback
			this.getChannelID = this.getUserID = function() {return -1;};
			this.getChannelName = this.getUserDisplayName = function() {return "";};
		}

		this.on('mount', function() {
			if (this.opts.columns) {
				this.root.dataset.cols = this.opts.columns;
			}

			if (this.refs.poster) {
				this.refs.poster.addEventListener('load', function() {
					if (self.parent && self.parent.opts.panels)
						self.parent.opts.panels.trigger('masonry-relayout');
				});
			}

			var body = self.refs.body ? self.refs.body.root : self.root.querySelector("[ref=body]");
			// Disabled while we do not have a DB entry for this - it works fine
			//if (this.canExpand = body.scrollHeight > 180)
			//	this.update();
		
			if (!this.opts.editing)
				this.updateOverflowIMG();
		});

		updateOverflow() {
			// If it weren't for the masonry-layout event, we could just use self.refs directly - but it is not defined in there for some reason.
			var body = self.refs.body ? self.refs.body.root : self.root.querySelector("[ref=body]");
			if (!body) {
				return;
			}

			// Disabled while we do not have a DB entry for this - it works fine
			var canExpand = false; //body.scrollHeight > 180;
			if (self.canExpand !== canExpand) {
				self.canExpand = canExpand;
				self.update();
				if (self.parent && self.parent.opts.panels)
					self.parent.opts.panels.trigger('masonry-relayout');
			}
		}

		updateOverflowIMG() {
			Array.prototype.slice.apply(this.root.querySelectorAll('img')).forEach(function(elem) {
				elem.addEventListener('load', function() {
					self.updateOverflow();
					self.parent.opts.panels.trigger('masonry-relayout');
				}, {
					once: true,
					passive: true
				});
			});
		}

		this.parent.opts.panels.on('masonry-layout', function() {
			self.updateOverflow();
		});

		this.on('update', function() {
			if (this.opts.columns)
				this.root.dataset.cols = this.opts.columns;
			this.panelURL = opts.panel.url ? "/site/referrer?go=" + encodeURIComponent(opts.panel.url) + "&ref=" + encodeURIComponent(window.location.href) : "";
			this.buttonIcon = this.getIcon();

			this.imageOnly = this.opts.panel.image_hash && !this.opts.panel.title && !this.opts.panel.body && !this.opts.panel.button;
		});

		this.on('updated', function() {
			this.updateOverflow();
			if (!this.opts.editing)
				this.updateOverflowIMG();
		});

		expand() {
			this.expanded = !this.expanded;
			this.update();
			if (this.parent && this.parent.opts.panels && this.parent.masonry)
				this.parent.masonry.layout();
		}

		openurl(e) {
			var url = opts.panel.button.url;
			if (url) {
				if (/^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/.test(url))
					window.open("mailto:" + url);
				else
					window.open("/site/referrer?go=" + encodeURIComponent(url) + "&ref=" + encodeURIComponent(window.location.href));
			}
		}

		getIcon() {
			if (this.opts.panel.button) {
				if (/^(https?:\/\/)?ko-fi\.com\/\S+$/i.test(opts.panel.button.url)) {
					return "fa-ptv-kofi";
				} else if (/^(https?:\/\/)?(streamlabs|twitchalerts)\.com\/\S+$/i.test(opts.panel.button.url)) {
					return "fa-ptv-streamlabs";
				} else if (/^(https?:\/\/)?(www\.)?paypal\.me\/[\w\d]+(\/(\d+([.,]\d{1,2})?(\w{3})?)?)?$/i.test(opts.panel.button.url)) {
					return "fa-paypal";
				} else if (/^(https?:\/\/)?(www\.)?patreon.com\/\S+$/i.test(opts.panel.button.url)) {
					return "fa-patreon";
				} else if (/^(https?:\/\/)?(www\.)?commiss\.io\/\S+$/i.test(opts.panel.button.url)) {
					return "fa-ptv-commissio";
				} else if (/^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/.test(opts.panel.button.url)) {
					return "fas fa-envelope";
				}
			}

			return null;
		}

		this.buttonIcon = this.getIcon();
	</script>
</description-panel>

<markdown>
	<span></span>

	<script>
		var content = opts.content;

		try {
			this.mixin('custom_emotes');
		} catch(e) {
			// Fallback
			this.getEmotes = function() {return {};};
		}
		// Could probably be done with a mixin
		var markdown = new showdown.Converter({
			simplifiedAutoLink: true,
			excludeTrailingPunctuationFromURLs: true,
			strikethrough: true,
			tables: true,
			simpleLineBreaks: true
		});

		var handleXSS = function(body) {
			// Whitelisted tags and props
			// We also always allow class and style
			var tagWhitelist = {
				a: ["href", "title", "target"],
				b: [],
				br: [],
				address: [],
				article: [],
				aside: [],
				blockquote: [],
				center: [],
				code: [],
				del: [],
				div: [],
				dl: [],
				em: [],
				figure: [],
				font: ["color"],
				footer: [],
				h1: [],
				h2: [],
				h3: [],
				h4: [],
				h5: [],
				h6: [],
				header: [],
				hgroup: [],
				hr: [],
				i: [],
				img: ["src", "title", "width", "height", "alt"],
				input: ["type", "disabled"],
				li: [],
				math: [],
				nav: [],
				ol: [],
				p: [],
				pre: [],
				section: [],
				strong: [],
				table: [],
				tbody: [],
				td: [],
				th: [],
				thead: [],
				tr: [],
				u: [],
				ul: []
			};

			var xssRoot = document.createElement('span');
			xssRoot.innerHTML = body.replace(/<(\/?)/g, "<$1safe-"); // Prevent event handlers from executing by neutering the default tag behaviour

			var preprocessAttrib = function(val) {
				// Really, IE? Comments within attributes?
				return val.toLowerCase().replace(/\s/g, "").replace(/\<!--.*?--\>/gi, "");
			};

			// Initial tag filtering
			[].slice.call(xssRoot.querySelectorAll("*")).forEach(function (elem) {
				if (typeof tagWhitelist[elem.tagName.substr(5).toLowerCase()] === "undefined") {
					elem.remove();
				}
			});

			// Re-query to avoid recursing over elements we don't even need
			[].slice.call(xssRoot.querySelectorAll("*")).forEach(function (elem) {
				var tagName = elem.tagName.substr(5); // Remove safe- prefix

				var allowedAttrs = tagWhitelist[tagName.toLowerCase()].slice();
				allowedAttrs.push("style", "class");

				var attrs = [].slice.apply(elem.attributes);
				for (var i = 0; i < attrs.length; ++i) {
					var attrName = attrs[i].name.toLowerCase();
					if (allowedAttrs.indexOf(attrName) === -1) {
						elem.removeAttribute(attrs[i].name);
						continue;
					}

					if (attrName === "href" || attrName === "src") {
						var attrVal = preprocessAttrib(attrs[i].value);
						var allowedPrefixes = ["http://", "https://", "ftp://", "/", "#"];
						// Because IE doesn't have Array.find()
						var attrValid = false;
						for (var j = 0; j < allowedPrefixes.length; ++j) {
							if (attrVal.indexOf(allowedPrefixes[j]) === 0) {
								attrValid = true;
								break;
							}
						}

						if (!attrValid) {
							elem.removeAttribute(attrName);
							continue;
						}
					} else if (attrName === "style") {
						// We don't directly access it on this iteration - it is more useful to us to just access these directly
						var stylesToRemove = [];
						for (var attr in elem.style) {
							if (elem.style.hasOwnProperty(attr) && typeof elem.style[attr] === "string") {
								var attrVal = preprocessAttrib(elem.style[attr]);
								if (attrVal.replace(/url\(['"]?/gi, "").indexOf("javascript:") === 0) {
									stylesToRemove.push(attr);
								}
							}
						}

						for (var j = 0; j < stylesToRemove.length; ++j) {
							elem.style.removeProperty(stylesToRemove[j]);
						}
					}
				}

				if (tagName.toLowerCase() === "a" && elem.href) {
					elem.setAttribute("href", "https://picarto.tv/site/referrer?go=" + encodeURIComponent(elem.getAttribute("href")) + "&ref=" + encodeURIComponent(document.location.href));
					elem.setAttribute("target", "_blank");
				}
			});

			return xssRoot.innerHTML.replace(/<(\/?)safe-/g, "<$1");
		};

		this.root.innerHTML = handleXSS(markdown.makeHtml(ptvEmoji.toHTML(opts.content, this.getEmotes())));
		content = opts.content;

		this.on('mount', function() {
			if (!ptvEmoji.initialized)
				ptvEmoji.initCallbacks.push(this.update);
		});

		this.on('update', function() {
			if (content !== opts.content) {
				this.root.innerHTML = handleXSS(markdown.makeHtml(ptvEmoji.toHTML(opts.content, this.getEmotes())));
				content = opts.content;
			}
		});
	</script>
</markdown>