<block-channel-videos id="video-container" class="video-container p-3 mb-2 animated-400 fadeIn d-none position-relative">
	<div class="row">
		<!-- Is Streamer -->
		<div class="col-12 d-flex mb-3 align-items-center" if={channelID === userID && channelProduct === 1} ref="streamerBar">
			<div class="text-muted mr-4">
				<span data-i18n="settings.channel.toggles.recordings">Enable Recordings</span>
				<i data-i18n="[title]settings.channel.toggles.recordings_hint" class="fas fa-fw fa-question-circle miniIcon " title="Your stream will be recorded as you are streaming" data-original-title="Your stream will be recorded as you are streaming"></i>
			</div>
			<input type="checkbox" class="checkslider" checked={opts.recordingsEnabled} onchange={toggleRecordings}>
			<a class="ml-auto" target="_blank" href="/settings/video">
				<button type="button" class="btn btn-sm mb-2">
					<span data-i18n="channel.videos.manage">Manage videos</span>
					<i class="far fa-arrow-right fontSize0-6 ml-2"></i>
				</button>
			</a>
		</div>

			<picarto-player
				class="d-block col-12 py-3 vod-player"
				if={currVideo}
				vod="https://recording-eu-1.picarto.tv/playhls/{currVideo}/index.m3u8"
				channel={channelName}
				product={channelProduct}
				ima={getIMA()}
				vod-thumb="https://recording-eu-1.picarto.tv/thumbnail/golive+{currVideo}.jpg"
				force-aspect=1
			/>

		<div if={opts.videos.length === 0} class="text-center text-muted py-3 col-12">
			<div class="fontSize2 mb-3">¯\_(ツ)_/¯</div>
			<div data-i18n="channel.videos.none">No videos available</div>
		</div>
		<div each={video in opts.videos} class="col-6 col-sm-6 col-lg-4 col-xl-3">
			<div class="mb-5">
				<a href="{playerPrefix + video.file}" onclick={openVideo.bind(this, video)} target="_blank" class="stream_video_container">
					<img class="imageresponsive round-corners" src="https://recording-eu-1.picarto.tv/thumbnail/{video.thumb}">
				</a>
				<div class="">
					<a href="{playerPrefix + video.file}" onclick={openVideo.bind(this, video)} class="d-block mt-2 text-white">{video.title}</a>
					<small class="d-flex align-items-center">
						<div class="text-muted mr-1"><i class="fas fa-fw fa-calendar mr-1" title="Creation Date"></i>{video.timestamp}</div>
						<div class="text-muted ml-auto">{video.views} <i class="fas fa-fw fa-eye mr-1" title="Views"></i></div>
					</small>
				</div>
			</div>
		</div>
	</div>

	<script>
		this.playerPrefix = "/videopopout/"
		this.channelID = opts.channelID;
		this.channelName = opts.channelName;
		this.channelProduct = opts.channelProduct;
		this.userID = opts.userID;
		this.currVideo = "";
		this.adsEnabled = opts.showAds && this.channelID !== this.userID;

		fixFilenames() {
			opts.videos.forEach(function(e) {
				if (e.file.substr(0, 7) === "golive+") {
					e.file = e.file.substr(7);
				}
			});
		}

		var setRecordings = debounce(function(newState) {
			$.post("/process/settings/recording", {type: newState});
		}, 1000, true);

		toggleRecordings(evt) {
			setRecordings(evt.currentTarget.checked ? "enable" : "disable");
		}

		openVideo(video, evt) {
			evt.preventDefault();
			if (this.currVideo) {
				this.currVideo = "";
				this.update();
			}
			this.currVideo = video.file;
			evt.preventUpdate = true;
			this.update();

			var top = 0;
			if (this.refs["streamerBar"]) {
				top += this.refs["streamerBar"].offsetHeight + this.refs["streamerBar"].offsetTop;
			}

			// Lazy way to do it, but it works
			$(this.root).animate({
				scrollTop: top
			}, 500);

			//window.open(this.playerPrefix + video.file, "__blank", "width=853,height=480,scrollbars=0,location=0").focus();
		}

		getIMA() {
			if (!this.adsEnabled) {
				return "";
			} else {
				return "//" + document.location.host + "/process/ads?pageurl=" + encodeURIComponent(document.location.href) + "&lang=" + (window.navigator.language || "en");
			}
		}

		window.ptvbus.on('logged-in', function(data) {
			this.userID = data.userid;
			this.adsEnabled = data.product === 0;
			this.update();
		}.bind(this));

		// Unload the player on switch tab, if nessecary
		window.ptvbus.on('switch-stream-tab', function(tab) {
			if (this.currVideo) {
				this.currVideo = "";
				this.update();
			}
		}.bind(this));


		this.on('before-mount', function() {
			this.fixFilenames();
		});

		this.on('update', function() {
			this.fixFilenames();
		});

		this.on('mount', function() {
			var scrollTimer = -1;

			var rootJq = $(this.root);

			rootJq.perfectScrollbar({suppressScrollX: true,handlers: ['click-rail', 'drag-scrollbar', 'keyboard', 'wheel', 'touch', 'selection']});
			rootJq.on("ps-scroll-y", function (evt) {
				evt.target.classList.add("scrolling");
				clearTimeout(scrollTimer);
				scrollTimer = setTimeout(function () {
					evt.target.classList.remove("scrolling");
				}, 1000);
			});
		}.bind(this));
	</script>
</block-channel-videos>