<block-channel-playerset>
	<div class="flexPlayerOuter {getFlexOuterClass()}">
		<span class='close-floating-player hidden' onclick={hideStream}><i class='far fa-times'></i></span>
		<div each={player, idx in players} class="centerFixed playerBackdrop {getFlexClass(player.pid)}" if={canShowPlayer(player.pid)}>
			<div class="position-relative animateAll {dimmed-player: focusDimmed !== 0 && focusDimmed !== player.channelID}">
				<!-- Stream hints -->
				<div if={player.pid === 1} show={showFollowHint} class="player-follow-hint bg-white py-2 pl-3 text-dark box-shadow m-2 round-corners animatedMid {hideFollowHint ? 'fadeOutRight' : 'fadeInRight'}">
					<i class="fas fa-heart-circle fontSize2 mr-3 text-primary"></i>
					<span>
						<h6 class="m-0">Enjoying the stream?</h6>
						<a href="#" onclick={follow} class="text-primary"><small>Click here to follow</small></a>
					</span>
					<span class="cursor-pointer ml-4 text-muted d-flex align-items-center justify-content-center p-3" onclick={hideStreamHint}>
						<i class="far fa-times"></i>
					</span>
				</div>
				<!-- Player -->
				<picarto-player
					class="as-16-9"
					id="playerHolder{player.pid}"
					pid={player.pid} channel={player.channelName} autoplay={player.autoplay}
					default-tech={getDefaultTech()}
					token={getPrivateToken()} online={player.online}
					has-offline-image={player.hasOfflineImage} vod-thumb={player.vodThumb}
					multi={players.length !== 1} debug={debug} popout={popout}
					ima={player.pid === 1 ? getIMA(player) : ""} index={index}
					mature={player.mature} show-mature-warning={showMatureWarning}
					product={player.product} viewers={viewers}
				/>
			</div>
		</div>
	</div>

	<script>
		this.players = opts.players || [
			{
				channelID: 7796,
				channelName: "Pikachu",
				autoplay: true,
				online: true,
				hasOfflineImage: true,
				vodThumb: "",
				adsEnabled: false,
				mature: false,
				product: 0,
				viewers: 0,
				minimized: false
			}
		];

		this.liveOverrides = [];
		this.focusDimmed = 0;
		this.expandedId = 0;

		this.debug = opts.debug || false;
		this.popout = opts.popout || false;
		this.index = opts.index || false;
		this.showMatureWarning = opts.showMatureWarning || false;
		this.poppedOut = false;
		this.poppedHidden = false;
		this.following = opts.following || false;
		this.showFollowHint = false;
		this.hideFollowHint = false; // Use to toggle

		this.followOverlayTimeout = -1;

		//Hide Stream hint function
		hideStreamHint(evt) {
			this.hideFollowHint = true;
		}

		follow() {
			var player = this.players[0];
			$.post("/process/channel", { follow: player.channelID }, function (data) {
				if (data === 'followed') {
					return;
				}

				window.ptvbus.trigger('follow-channel', {id: player.channelID, name: player.channelName});
				if (data == 'followerror') {
					displayErrorMsg(100);
				} else if (data == 'notallowed') {
					$('#menu_login_modal').modal('show');
				} else if (data == 'follownotallowed') {
					displayNotificationMsg(2);
				}
			});
		}

		hideStream() {
			if($('#player-container').hasClass("on-videos")){
				$('#player-container').hide();
			}else{
				$('block-channel-playerset').addClass("hidden");
			}
		}


		reloadPlayer(idx) {
			if (idx < 0 || this.players.length <= idx) {
				return;
			}

			var elem = this.players.splice(idx, 1)[0];
			this.update();
			this.players.splice(idx, 0, elem);
			this.update();
		}

		canShowPlayer(pid) {
			var player = this.players.find(function(elem) {return elem.pid === pid;});

			if (player.minimized) {
				return false;
			} else if (pid === 1) {
				return true;
			} else {
				return player.online;
			}
		}

		getFlexClass(pid) {
			if (this.players.filter(function(elem) {return !elem.minimized && (elem.online || elem.pid === 1)}).length < 2) {
				// If this is 0, it means we probably have one forced online.
				// If all are hidden, the class doesn't matter.
				// This can also be 0 if none are explicitly hidden but we force show the
				// first player to give a placeholder.
				return "flexPlayerInnerFull";
			} else {
				return "flexPlayerInner";
			}
		}

		getDefaultTech() {
			if (window.localStorage && window.localStorage["forceTech"]) {
				return window.localStorage["forceTech"];
			}
			var uaString = navigator.userAgent;
			var uaPairs = [
				{ // Vivaldi
					allow: ["Vivaldi/"],
					deny: []
				},
				{ // IE
					allow: ["; MSIE ", "; Edge ", "; Trident "],
					deny: []
				},
				{ // Opera
					allow: ["OPR/", "Opera/"],
					deny: [],
				},
				{ // Safari
					allow: ["Safari/"],
					deny: ["Chrome/", "Chromium/"]
				},
				{
					allow: ["Firefox/", "Seamonkey/"],
					deny: []
				},
				{ // Windows XP
					allow: ["(Windows NT 5.1; "],
					deny: []
				}
			];
			// Check IE
			var mp4Supported = !uaPairs.find(function(elem) {
				return !!elem.allow.find(function(allow) { return uaString.indexOf(allow) !== -1; }) &&
						!elem.deny.find(function(allow) { return uaString.indexOf(allow) !== -1; });
			});

			if (mp4Supported) {
				return "video/mp4";
			} else {
				return "application/x-mpegurl";
			}
		}

		getPrivateToken() {
			var path = document.location.pathname.split("/");
			if (path.length >= 3) {
				return path[2];
			}
			return "public";
		}

		getIMA(player) {
			if (!player.adsEnabled) {
				return "";
			} else {
				return "//" + document.location.host + "/process/ads?pageurl=" + encodeURIComponent(document.location.href) + "&lang=" + (window.navigator.language || "en");
			}
		}

		getFlexOuterClass() {
			switch (this.players.filter(function(elem) {return !elem.minimized && (elem.online || elem.pid === 1);}).length || 1) {
				case 1:
					return "single";
				case 2:
					return "duo";
				case 3:
					return "triple";
				default:
					return "quad";
			}
		}

		updatePlayerPids() {
			var pids = [1,2,3,4];

			// Remove in-use pids from the list
			this.players.forEach(function(elem) {
				if (!elem.hasOwnProperty("pid")) {
					return;
				}

				pids.splice(pids.indexOf(elem.pid), 1); // Remove in-use pid from the list
			}.bind(this));

			this.players = this.players.map(function(elem) {
				if (!elem.hasOwnProperty("pid")) {
					elem.pid = pids.shift();
				}
				return elem;
			}.bind(this));
		}

		setPlayers(channels) {
			this.players = channels.map(function(elem) {
				var player = this.players.find(function(playerElem) { return elem.channel === playerElem.channelID; });
				if (player) {
					return player;
				} else {
					var liveOverride = this.liveOverrides.indexOf(elem.channel);
					if (liveOverride !== -1) {
						this.liveOverrides.splice(liveOverride, 1);
					}
					return {
						channelID: elem.channel,
						channelName: elem.channelName,
						autoplay: false,
						online: elem.live || liveOverride !== -1,
						hasOfflineImage: true,
						vodThumb: "",
						adsEnabled: false,
						mature: false,
						product: 0,
						viewers: 0,
						minimized: this.expandedId !== 0 ? this.expandedId !== elem.channel : false,
					};
				}
			}.bind(this));

			this.update();
		}

		playChannel(channelName) {
			var players = this.tags["picarto-player"];
			if (!Array.isArray(players)) {
				players = [players];
			}


			players.forEach(function(elem) {
				if (elem.opts.channel === channelName) {
					// We defer this in case we initialized the player in the same call stack - it needs a moment to init
					setTimeout(function() {
						var p = elem.getPlayer();
						if (!p) {
							console.error("Could not get player to play");
							return;
						}

						if (elem.isOnline()) {
							p.play();
						}
					}, 10);
				}
			});
		}

		updateFavicon() {
			if (this.players[0].online) {
				setFavicon("/images/favicon_live.ico");
			} else {
				setFavicon("/images/favicon.ico");
			}
		}

		this.tryShowOverlay = function tryShowOverlay() {
			var canShow = function canShow() {
				return this.players[0].online && !this.following && !this.showFollowHint;
			}.bind(this);

			if (canShow()) {
				if (this.followOverlayTimeout !== -1) {
					this.followOverlayTimeout = setTimeout(function(){
						if (canShow()) {
							this.showFollowHint = true;
							this.update();
							
							setTimeout(function() {
								this.hideFollowHint = true;
								this.update();
							}.bind(this), 1000*30);
						}
					}.bind(this), 1000*60*(8 + (Math.random() * 12)));
				}
			} else {
				clearTimeout(this.followOverlayTimeout);
				this.followOverlayTimeout = -1;
			}
		}

		this.on('mount', function() {
			this.tryShowOverlay();
		});

		this.on('update', function() {
			this.updatePlayerPids();
			this.updateFavicon();
			this.tryShowOverlay();
		});

		window.ptvbus.on('player-mature', function(data) {
			var player = this.players.find(function(elem) { return elem.channelID === data.id; });
			if (!player) {
				return;
			}

			var players = this.tags["picarto-player"];
			if (!Array.isArray(players)) {
				players = [players];
			}
			var playerElem = players.find(function(elem) { return elem.opts.pid === player.pid; });

			playerElem.setMature(data.state);
			player.mature = data.state;
			this.update();
		}.bind(this));

		window.ptvbus.on('multi-minimize-player', function(channelID) {
			var player = this.players.find(function(e) {return e.channelID === channelID});
			player.minimized = !player.minimized;
			this.expandedId = 0;
			this.update();
			if (!player.minimized) {
				this.playChannel(player.channelName)
			}
			window.ptvbus.trigger('multi-minimize-player-update', {id: player.channelID, state: player.minimized});
		}.bind(this));

		window.ptvbus.on('multi-expand-player', function(channelID) {
			if (this.expandedId === channelID) {
				this.expandedId = 0;
				this.players.forEach(function(elem) {elem.minimized = false;});
			} else {
				this.expandedId = channelID;
				this.players.forEach(function(elem) {elem.minimized = elem.channelID !== channelID;});
			}
			this.update();
			window.ptvbus.trigger('multi-expand-player-update', this.expandedId);
		}.bind(this));

		window.ptvbus.on('set-player-poster', function(data) {
			// TODO THIS
			var players = this.tags["picarto-player"];
			if (Array.isArray(players)) {
				players.forEach(function(elem) {
					if (elem.opts.channel === data.channel && elem.getPlayer()) {
						elem.getPlayer().poster(data.uri);
					}
				});
			} else if (players.opts.channel === data.channel && players.getPlayer()) {
				players.getPlayer().poster(data.uri);
			}
		}.bind(this));

		window.ptvbus.on('disable-ads', function(pid) {
			var player = this.players.find(function(elem) { return pid === elem.pid; });
			player.adsEnabled = false;
			this.update();
		}.bind(this));

		window.ptvbus.on('enable-ads', function(pid) {
			var player = this.players.find(function(elem) { return pid === elem.pid; });
			player.adsEnabled = true;
			this.update();
		}.bind(this));

		window.ptvbus.on('reload-stream', function(pid) {
			var idx = this.players.findIndex(function(elem) { return pid === elem.pid; });
			this.players[idx] = Object.assign({}, this.players[idx]);
			this.update();
		}.bind(this));

		window.ptvbus.on('channel-live', function(data) {
			var player = this.players.find(function(elem) {return elem.channelID === data.id});

			if (player === undefined) {
				// Queue up going live if the player isn't yet visible
				var liveIndex = this.liveOverrides.indexOf(data.id);
				if (data.live && liveIndex === -1) {
					this.liveOverrides.push(data.id);
				} else if (!data.live && liveIndex !== -1) {
					this.liveOverrides.splice(liveIndex, 1);
				}
				return;
			} else if (player.online === data.live) {
				return;
			}

			var playerTag = [].concat(this.tags["picarto-player"]).find(function(elem) { return elem.opts.pid === player.pid });
			if (!playerTag) {
				// This is not a valid player yet, let riot and the player itself handle it later
				player.online = data.live;
				this.update();
				return;
			}

			var tries = 3;

			var setPlayerState = function() {
				if (playerTag.getPlayer()) {
					playerTag[data.live ? "online" : "offline"]();
				} else if (tries-- > 0) {
					setTimeout(setPlayerState, 5);
				}
			};
			if (!playerTag.getPlayer()) {
				setTimeout(setPlayerState, 0);
			} else {
				setPlayerState();
			}
			player.online = data.live;

			if (!player.online && player.channelID === this.expandedId) {
				this.expandedId = 0;
				this.players.forEach(function(elem) {elem.minimized = false;});
				this.update();
				window.ptvbus.trigger('multi-expand-player-update', this.expandedId);
			} else {
				this.update();
			}
		}.bind(this));

		window.ptvbus.on('multi-set-users', function(multiInfo) {
			// Avoid showing overlay if no changes are to be made
			if (multiInfo.guests.length === this.players.length - 1) {
				var channels = this.players.map(function(elem) { return elem.channelID; })
				if (channels.indexOf(multiInfo.host.channel) !== -1) {
					if (!multiInfo.guests.find(function(elem) {
						return channels.indexOf(elem.channel) === -1;
					})) {
						return;
					}
				}
			}

			window.ptvbus.trigger('userbar-notification', {
				text: "Multistream layout updated",
				actions: [{text: "Update", multiInfo: multiInfo}]
			});

			window.ptvbus.one('userbar-action', function(data) {
				if (!data || data.text !== "Update") {
					return;
				}

				if (data.multiInfo.guests.length === 0) {
					this.players = [this.players[0]];
					this.update();
					window.ptvbus.trigger('multi-update-users', [{
						channel: this.players[0].channelID,
						channelName: this.players[0].channelName
					}]);
					return;
				}

				// We do this to ensure our own name shows first in the user bar
				var ourElem;

				var channels = []
					.concat(multiInfo.host, data.multiInfo.guests)
					.filter(function(elem) {
						if (elem.channel != this.players[0].channelID) {
							return true;
						} else {
							ourElem = elem;
							return false;
						}
					}.bind(this))

				channels.unshift(ourElem);

				this.setPlayers(channels);

				window.ptvbus.trigger('multi-update-users', channels);
			}.bind(this))
		}.bind(this));

		window.ptvbus.on('shade-multi-player', function(channelID) {
			if (this.focusDimmed !== channelID) {
				this.focusDimmed = channelID;
				this.update();
			}
		}.bind(this));

		window.ptvbus.on('switch-stream-tab', function(state) {
			var playerContainer = $('#player-container');
			switch(state){
				case "videos":
					$('.close-floating-player').removeClass("hidden");
					break;
				case "stream":
					$('.close-floating-player').addClass("hidden");
					break;
			}
			$('block-channel-playerset').removeClass("hidden");
			this.update();
		}.bind(this));

		window.ptvbus.on('follow-channel', function(data) {
			if (this.players[0].channelID === data.id) {
				this.hideFollowHint = true;
				this.following = true;
				this.update();
			}
		}.bind(this));

		this.updatePlayerPids();
	</script>
</block-channel-playerset>